#!/bin/sh

start_agent()
{
    export LD_LIBRARY_PATH=../lib/:/opt/zpa/lib:$LD_LIBRARY_PATH
    ./zpdp -loglevel WARNING &
	if [ "$?" = "0" ] ; then
		echo "Agent started"
	else
		echo "Error starting the process"
	fi
}

stop_agent()
{
    export LD_LIBRARY_PATH=../lib/:/opt/zpa/lib:$LD_LIBRARY_PATH
    ./zpdp -loglevel WARNING -shutdown
    sleep 5
    echo "Agent stopped"
}

restart_agent()
{
	stop_agent
	sleep 3
	start_agent
}

check_root()
{
	if [ $(id -u) != 0 ] ; then
    		echo "Please login as root with <sudo -s> command and try again"
    		exit 0
	fi
}

check_root

case "$(pidof zpdp | wc -w)" in

0)  if [ "$1" = "start" ] ; then
		start_agent
	elif [ "$1" = "stop" ] ; then
		echo "ERROR : Not Running"
	elif [ "$1" = "restart" ] ; then
		echo "Agent already stopped... Starting now"
		start_agent
    else
    	echo "ERROR : Invalid Command"
    fi
    ;;
*)  if [ "$1" = "start" ] ; then
		echo "Agent already running"
	elif [ "$1" = "stop" ] ; then
		stop_agent
	elif [ "$1" = "restart" ] ; then
		echo "Restarting Now... Please wait for few seconds"
		restart_agent
    else
    	echo "ERROR : Invalid Command"
    fi
    ;;
esac
