#!/bin/sh
curl_version="$(curl --version | awk 'NR==1{print $2}')"
ssl_version="$(openssl version | awk 'NR==1{print $2}')"
version() { echo "$@" | awk -F. '{ printf("%d%03d%03d\n", $1,$2,$3); }'; }
check_lib()
{
	# In many cases, a symbolic link is needed, 
	# as libcurl is not found in /usr/lib or /usr/local dirs. 
	echo "Removing old links.."
	if [ -f "../lib/libcurl.so.4" ]; then
		# Remove the old, probably outdated link. 
		rm ../lib/libcurl.so.4
	fi
	if [ -f "../lib/libssl.so" ]; then
		# Remove the old, probably outdated link.
		rm ../lib/libssl.so
	fi
	if [ -f "../lib/libcrypto.so" ]; then
		# Remove the old, probably outdated link.
		rm ../lib/libcrypto.so
	fi
	echo "checking Curl version : $curl_version"
	echo "checking libssl version : $ssl_version"
	
	echo "Updating dependecies..."
	if [ $(version $curl_version) -lt $(version "7.49.1") ]; then
		echo "Using curl version bundled with agent."
		ln -s ../lib/libcurl.so.4.4.0 ../lib/libcurl.so.4
	else
		echo "OS curl version used. "
		if [ -f "../lib/libcurl.so.4.4.0" ]; then
			mv ../lib/libcurl.so.4.4.0 ../lib/libcurl.so.old
		fi
	fi
	if [ $(version $ssl_version) -lt $(version "1.1.1") ]; then
		echo "Using curl version bundled with agent."
		ln -s ../lib/libssl.so.1.1 ../lib/libssl.so
		ln -s ../lib/libcrypto.so.1.1 ../lib/libcrypto.so
	else
		echo "OS ssl version used. "
		if [ -f "../lib/libssl.so.1.1" ]; then
			mv ../lib/libssl.so.1.1 ../lib/libssl.so.old
		fi 
		if [ -f "../lib/libcrypto.so.1.1" ]; then
			mv ../lib/libcrypto.so.1.1 ../lib/libcrypto.so.old
		fi
	fi
	
}

check_lib

