/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.instrumentation.interceptor.CustomPointcutProperties;
import com.manageengine.apminsight.agent.metrics.AppParamMetric;
import com.manageengine.apminsight.agent.metrics.MetricType;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.exception.CustomLogRecord;
import com.manageengine.apminsight.agent.tracing.exception.ErrorThrowable;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.api.CustomAPITracker;
import com.manageengine.org.apache.logging.log4j.Level;

public final class JavaAgentAPIHandler {
    private static final String INPUT_VALIDATOR_REGEX = "^[\\w\\. _-]+$";

    private static boolean isAgentEnabled() {
        return JavaAgent.getInstance().getAgentConfig().agentVerified;
    }

    public static void handleException(long timestamp, String message, Throwable throwable) {
        try {
            if (!JavaAgentAPIHandler.isAgentEnabled()) {
                return;
            }
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.currentTrackersCount() == 0) {
                SequenceSpace.SEQUENCE_BOOK.remove();
                JavaAgent.logger.warn("[JavaAgentAPIHandler] No active transaction to associate the exception. " + throwable.getClass().getName());
                return;
            }
            if (throwable.getClass().getName().matches(seqSpace.getConfig().excludeExceptionsRegex)) {
                JavaAgent.logger.debug("[JavaAgentAPIHandler] Marked exception is found in ignore list, dropping it");
                return;
            }
            message = message != null && message.matches(INPUT_VALIDATOR_REGEX) ? message : null;
            CustomLogRecord logRecord = new CustomLogRecord(timestamp, message, new ErrorThrowable(throwable));
            seqSpace.getLogRecordBag().add(logRecord);
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[JavaAegntAPIHandler] Exception while handling API exception.", th);
        }
    }

    public static Tracker startTracker(String name, String componentName) {
        try {
            if (!JavaAgentAPIHandler.isAgentEnabled()) {
                return null;
            }
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.listenBlockFlag == 1) {
                return null;
            }
            String string = name != null && name.matches(INPUT_VALIDATOR_REGEX) ? (name.length() > 64 ? name.substring(0, 64 - "..".length()) + ".." : name) : (name = null);
            Component component = componentName != null && componentName.matches(INPUT_VALIDATOR_REGEX) ? Component.get(componentName.length() > 32 ? componentName.substring(0, 32) : componentName) : null;
            CustomPointcutProperties customPointcut = new CustomPointcutProperties(name, component);
            Tracker tracker = new CustomAPITracker(customPointcut, null, null);
            tracker = seqSpace.transformTracker(tracker);
            return tracker;
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[JavaAgentAPIHandler] Exception while starting a custom tracker.", th);
            return null;
        }
    }

    public static void stopTracker(Tracker tracker, Throwable throwable) {
        try {
            if (JavaAgentAPIHandler.isAgentEnabled() && tracker != null) {
                if (throwable == null) {
                    JavaAgent.getHandler().exitTracker(tracker, 0, null);
                } else {
                    JavaAgent.getHandler().exitTracker(tracker, throwable);
                }
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[JavaAgentAPIHandler] Exception while stopping a custom tracker.", th);
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            seqSpace.cleanAndUpdateOnTrackerError(tracker);
        }
    }

    public static void addParameter(String key, Object value) {
        try {
            SequenceSpace seqSpace;
            if (!JavaAgentAPIHandler.isAgentEnabled()) {
                return;
            }
            if (key != null && key.matches(INPUT_VALIDATOR_REGEX) && (seqSpace = SequenceSpace.SEQUENCE_BOOK.get()).getRootTracker() != null) {
                seqSpace.addCustomParameter(key, value != null ? value.toString() : null);
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[JavaAgentAPIHandler] Unable to add custom parameter. Exception: " + th.getMessage());
        }
    }

    public static void increment(String key, double value) {
        JavaAgentAPIHandler.addCustomMetric("sum", key, value);
    }

    public static void average(String key, double value) {
        JavaAgentAPIHandler.addCustomMetric("average", key, value);
    }

    private static void addCustomMetric(String metricName, String key, double value) {
        try {
            if (!JavaAgentAPIHandler.isAgentEnabled()) {
                return;
            }
            if (key != null && key.matches(INPUT_VALIDATOR_REGEX)) {
                MetricStore metricStore = MetricStoreController.getMetricStore();
                AppParamMetric metricData = (AppParamMetric)metricStore.getMetric("appparam", metricName, MetricType.APP_PARAMS, false).getMetricData();
                metricData.recordData(key, value, metricName);
            } else {
                JavaAgent.logger.warn("[JavaAgentAPIHandler] Invalid name for App param attribute: '" + key + "'");
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[JavaAgentAPIHandler] Unable to add custom metric to metricstore. Exception: " + th.getMessage());
        }
    }

    public static void setTransactionName(String customTxnName) {
        try {
            if (!JavaAgentAPIHandler.isAgentEnabled()) {
                return;
            }
            SequenceSpace seqSpace = SequenceSpace.SEQUENCE_BOOK.get();
            if (seqSpace.currentTrackersCount() == 0) {
                SequenceSpace.SEQUENCE_BOOK.remove();
                JavaAgent.logger.debug("[JavaAgentAPIHandler] No active transaction to set transaction name");
                return;
            }
            seqSpace.setTransactionName(customTxnName);
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[JavaAgentAPIHandler] Unable to set transaction name to the transaction. Exception: " + th.getMessage());
        }
    }
}

