/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.response.ResponseCode;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.HashMap;
import java.util.Map;

public final class ResponseCodeHandler {
    private static Map<Integer, ResponseCode> responseCodeCache = new HashMap<Integer, ResponseCode>();

    public static boolean processResponseCode(ContextInfo info, ResponseCode rCode) {
        if (rCode == null) {
            return Boolean.TRUE;
        }
        JavaAgent.logger.log(Level.DEBUG, rCode.getResponseCode() + ": " + rCode.getResponseMessage());
        JavaAgent agent = JavaAgent.getInstance();
        switch (rCode) {
            case LICENSE_EXPIRED: 
            case LICENSE_INSTANCES_EXCEEDED: {
                return agent.deleteAgent(info, 15);
            }
            case LICENSE_OK: {
                break;
            }
            case UNMANAGE_AGENT: {
                return agent.disableAgent(info);
            }
            case MANAGE_AGENT: {
                return agent.enableAgent(info);
            }
            case INVALID_AGENT: 
            case DELETE_AGENT: {
                return agent.deleteAgent(info, 3);
            }
        }
        return true;
    }

    public static boolean processResponseCode(ContextInfo info, Integer responseCodeAsInt) {
        return ResponseCodeHandler.processResponseCode(info, responseCodeCache.get(responseCodeAsInt));
    }

    public static ResponseCode getResponseCode(Integer responseCodeAsInt) {
        return responseCodeCache.get(responseCodeAsInt);
    }

    static {
        for (ResponseCode rCode : ResponseCode.values()) {
            responseCodeCache.put(rCode.getResponseCode(), rCode);
        }
    }
}

