/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.autoupgrade;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.agentupgrade.AgentUpgradeStatusCode;
import com.manageengine.apminsight.agent.autoupgrade.AgentUpgrader;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.exception.FatalException;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.ondemand.OnDemandTask;
import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import com.manageengine.apminsight.agent.service.JavaAgentService;
import com.manageengine.apminsight.agent.util.FileUtil;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.apminsight.agent.util.SecurityUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.apminsight.agent.util.Utils;
import com.manageengine.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.manageengine.org.apache.hc.client5.http.classic.methods.HttpPost;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.manageengine.org.apache.hc.core5.http.ContentType;
import com.manageengine.org.apache.hc.core5.http.io.entity.EntityUtils;
import com.manageengine.org.apache.hc.core5.http.io.entity.StringEntity;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.json.simple.JSONValue;
import com.manageengine.org.json.simple.parser.JSONParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class AgentUpgraderService
extends OnDemandTask
implements AgentServiceConstants,
JavaAgentConstants {
    public static final String UPDATE_FILE_NAME = "apminsight-javaagent.zip";
    private static final long UPDATE_FILE_MIN_SIZE_IN_MB = 4L;
    public static final String UPDATE_PROCESS_TEMP_DIR_NAME = "temp";
    private JavaAgentConfig agentConfig = JavaAgent.getInstance().getAgentConfig();
    private JavaAgentService agentService = JavaAgent.getInstance().getAgentService();
    private AgentLogger logger = this.agentConfig.getLogger();
    private static final int READ_BUFFER_SIZE = 1024;
    private static boolean updateFileDownloadInProgress = false;
    private static final short MAX_RETRY_COLLECTOR = 3;

    public AgentUpgraderService() {
        super("agent-update-service", OnDemandTask.TaskWeightage.LITE);
    }

    private String getStaticDownloadUrl() {
        return this.agentConfig.getDataCenter().getStaticDownloadDomain() + "/apminsight/agents/apminsight-javaagent.zip";
    }

    private String getAgentUpdateDownloadUrl() {
        StringBuilder sb = new StringBuilder(this.agentConfig.getAgentCollectorConnectionURL());
        sb.append("downloadupdate");
        sb.append(this.agentService.getConnectionVitalQueryString(ContextInfoManager.getInstance().getDefaultContextInfo().getInstanceID()));
        return sb.toString();
    }

    @Override
    public void runTask() {
        if (updateFileDownloadInProgress) {
            JavaAgent.logger.warn("Duplicate AgentUpgraderService call. Another update file download is in progress..");
            return;
        }
        updateFileDownloadInProgress = true;
        this.logger.info("AgentUpdateReceiver started.");
        File apminsightHomeDir = JavaAgentUtil.getAgentInstallDirectory();
        if (apminsightHomeDir == null || !apminsightHomeDir.exists() || !apminsightHomeDir.canWrite()) {
            String msg = "Javaagent update couldn't proceed!! Directory not exists (or) write permission disabled. " + apminsightHomeDir.getAbsolutePath();
            this.logger.fatal(msg);
            AgentUpgraderService.intimateErrToCollector(msg);
            return;
        }
        try {
            this.downloadUpdate(apminsightHomeDir);
            this.logger.info("javaagent update - downloaded successfully to " + apminsightHomeDir.getAbsolutePath());
        }
        catch (RuntimeException e) {
            AgentUpgraderService.intimateErrToCollector("Agent checksum verification failed");
            return;
        }
        catch (Exception e) {
            this.logger.log(Level.FATAL, "javaagent update - download failed!", e);
            AgentUpgraderService.intimateErrToCollector("Javaagent download failed. Error saving the new agent. Refer logs for details");
            return;
        }
        AgentUpgraderService.intimateUpdateFileDownloadSuccessToCollector();
        File tempDir = new File(apminsightHomeDir, UPDATE_PROCESS_TEMP_DIR_NAME);
        if (tempDir.exists()) {
            try {
                FileUtil.cleanDirectory(tempDir);
                tempDir.delete();
                this.logger.info("javaagent update - existing temporary directory deleted.");
            }
            catch (Exception e) {
                this.logger.log(Level.ERROR, "unable to delete the existing temporary directory", e);
                AgentUpgraderService.intimateErrToCollector("unable to delete the existing temporary directory");
                return;
            }
        }
        try {
            File updateFile = new File(apminsightHomeDir, UPDATE_FILE_NAME);
            FileUtil.unzip(updateFile, tempDir);
            this.logger.info("javaagent update - unzipped to " + tempDir.getAbsolutePath());
            updateFile.delete();
        }
        catch (Exception e) {
            this.logger.log(Level.ERROR, "javaagent update - unzipping to temp dir " + tempDir.getAbsolutePath() + " failed!", e);
            AgentUpgraderService.intimateErrToCollector("unzipping the update to temporary directory failed");
            return;
        }
        try {
            AgentUpgraderService.updateNewConfFile(apminsightHomeDir, tempDir, "apminsight.conf");
            this.logger.info("javaagent update - new conf files are filled in with right values");
        }
        catch (Exception e) {
            this.logger.log(Level.ERROR, "javaagent update - updating new conf files failed.", e);
            AgentUpgraderService.intimateErrToCollector("failed to update new configuration files");
            return;
        }
        File agentLocation = JavaAgentUtil.getAgentJarDirPath();
        if (agentLocation == null || !agentLocation.exists() || !agentLocation.canWrite()) {
            this.logger.fatal("Javaagent update couldn't proceed!! Directory not exists (or) write permission disabled. " + agentLocation.getAbsolutePath());
            AgentUpgraderService.intimateErrToCollector("agent located directory not exists or write permission disabled");
            return;
        }
        AgentUpgrader upgrader = new AgentUpgrader(apminsightHomeDir, tempDir, agentLocation, this.logger);
        JavaAgent.getInstance().setAgentUpgrader(upgrader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadUpdate(File destDir) throws Exception {
        CloseableHttpClient client = JavaAgent.getInstance().getAgentService().getHttpClient();
        CloseableHttpResponse response = null;
        String checksumUrl = null;
        try {
            HttpPost request = new HttpPost(this.getAgentUpdateDownloadUrl());
            StringEntity json = new StringEntity(JSONValue.toJSONString(new LinkedHashMap<Object, Object>(){
                {
                    this.put("type", "Java");
                    this.put("status-code", AgentUpgradeStatusCode.AGENT_REQUEST.name());
                }
            }), ContentType.APPLICATION_JSON);
            request.setEntity(json);
            response = client.execute(request);
            BufferedReader in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            Map data = (Map)new JSONParser().parse(in);
            in.close();
            checksumUrl = (String)((Map)data.get("data")).get("checksum_url");
            String url = (String)((Map)data.get("data")).get("download_url");
            HttpGet downloadRequest = new HttpGet(url);
            response = client.execute(downloadRequest);
            this.logger.info("[AgentUpdateReceiver] Downloading new version from " + url);
        }
        catch (Exception e) {
            this.logger.log(Level.WARN, "Unable to download new agent version", e);
            throw e;
        }
        File file = new File(destDir, UPDATE_FILE_NAME);
        if (file.exists()) {
            file.delete();
        }
        file.createNewFile();
        FileOutputStream fos = new FileOutputStream(file);
        InputStream is = response.getEntity().getContent();
        try {
            int bytesRead;
            byte[] buffer = new byte[1024];
            while ((bytesRead = is.read(buffer)) > 0) {
                fos.write(buffer, 0, bytesRead);
            }
        }
        finally {
            is.close();
            fos.close();
        }
        long updateFileLengthInMB = JavaAgentUtil.convertBytesToMB(file.length());
        this.logger.info("javaagent update - update file: " + file.getName() + " of size " + updateFileLengthInMB + "mb saved.");
        if (updateFileLengthInMB < 4L) {
            throw new FatalException("downloaded agent file size less than expected size. Received file of size: " + updateFileLengthInMB + "MB");
        }
        if (!StringUtils.isEmptyString(checksumUrl)) {
            HttpGet httpGet = new HttpGet(checksumUrl);
            JavaAgent.logger.debug("Verifying checksum of downloaded agent jar from {}", checksumUrl);
            response = client.execute(httpGet);
            String hash = EntityUtils.toString(response.getEntity()).trim();
            if (!SecurityUtil.verifySHA256Checksum(file, hash)) {
                this.logger.warn("Javaagent Update - file SHA256 verification failed. Aborting agent update");
                throw new RuntimeException("SHA256 checksum validation failed. Agent update aborted");
            }
            this.logger.debug("Checksum verification successful for the newly downloaded update");
        }
    }

    public static void updateNewConfFile(File confSourceDir, File confDestDir, String confFileName) {
        try {
            File source = new File(confSourceDir, confFileName);
            if (!source.exists()) {
                return;
            }
            File dest = new File(confDestDir, confFileName);
            FileUtil.refillPropertiesFile(dest, Utils.getContentAsProps(source), true);
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Error while copying keys to new conf file", e);
        }
    }

    public static void resetDownloadInProgressFlag() {
        updateFileDownloadInProgress = false;
        JavaAgent.logger.info("AgentUpgraderService - downloadInProgressFlag resetted.");
    }

    public static void intimateErrToCollector(final String errMessage) {
        for (int retry = 1; retry <= 3; retry = (int)((short)(retry + 1))) {
            try {
                JavaAgent.getInstance().getAgentService().sendDataToServer(ContextInfoManager.getInstance().getDefaultContextInfo(), "downloadupdate", new LinkedHashMap<Object, Object>(){
                    {
                        this.put("type", "Java");
                        this.put("status-code", AgentUpgradeStatusCode.ERROR_OCCURRED.name());
                        this.put("status-message", errMessage);
                    }
                });
                AgentUpgraderService.resetDownloadInProgressFlag();
                break;
            }
            catch (Exception e) {
                JavaAgent.logger.log(Level.FATAL, "couldn't able to intimate upgrade fail error to collector. Retrying(" + retry + '/' + 3 + ") AgentUpgraderService downloadInProgressFlag not reset.", e);
                try {
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
    }

    public static void intimateUpdateFileDownloadSuccessToCollector() {
        for (int retry = 1; retry <= 3; retry = (int)((short)(retry + 1))) {
            try {
                JavaAgent.getInstance().getAgentService().sendDataToServer(ContextInfoManager.getInstance().getDefaultContextInfo(), "downloadupdate", new LinkedHashMap<Object, Object>(){
                    {
                        this.put("type", "Java");
                        this.put("status-code", AgentUpgradeStatusCode.DOWNLOAD_SUCCESS.name());
                    }
                });
                AgentUpgraderService.resetDownloadInProgressFlag();
                break;
            }
            catch (Exception e) {
                JavaAgent.logger.log(Level.WARN, "couldn't able to intimate collector about update file successful download. Retrying(" + retry + '/' + 3 + ") AgentUpgraderService downloadInProgressFlag not reset.", e);
                continue;
            }
        }
    }

    @Override
    public boolean abortTask() {
        return false;
    }
}

