/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.communication.http;

import com.manageengine.org.bouncycastle.asn1.x509.Certificate;
import com.manageengine.org.bouncycastle.crypto.tls.CertificateRequest;
import com.manageengine.org.bouncycastle.crypto.tls.DefaultTlsClient;
import com.manageengine.org.bouncycastle.crypto.tls.TlsAuthentication;
import com.manageengine.org.bouncycastle.crypto.tls.TlsClientProtocol;
import com.manageengine.org.bouncycastle.crypto.tls.TlsCredentials;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.LinkedList;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private SecureRandom secureRandom = new SecureRandom();

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoclose) throws IOException {
        if (socket == null) {
            socket = new Socket();
        }
        if (!socket.isConnected()) {
            socket.connect(new InetSocketAddress(host, port));
        }
        TlsClientProtocol tlsClientProtocol = new TlsClientProtocol(socket.getInputStream(), socket.getOutputStream(), this.secureRandom);
        return this.createCustomTLSSocket(host, tlsClientProtocol);
    }

    private SSLSocket createCustomTLSSocket(String host, final TlsClientProtocol tlsClientProtocol) {
        return new SSLSocket(){
            private java.security.cert.Certificate[] peerCerts;

            @Override
            public InputStream getInputStream() throws IOException {
                return tlsClientProtocol.getInputStream();
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                return tlsClientProtocol.getOutputStream();
            }

            @Override
            public synchronized void close() throws IOException {
                tlsClientProtocol.close();
            }

            @Override
            public void addHandshakeCompletedListener(HandshakeCompletedListener arg0) {
            }

            @Override
            public boolean getEnableSessionCreation() {
                return false;
            }

            @Override
            public String[] getEnabledCipherSuites() {
                return null;
            }

            @Override
            public String[] getEnabledProtocols() {
                return null;
            }

            @Override
            public boolean getNeedClientAuth() {
                return false;
            }

            @Override
            public SSLSession getSession() {
                return new SSLSession(){

                    @Override
                    public void removeValue(String name) {
                    }

                    @Override
                    public void putValue(String name, Object value) {
                    }

                    @Override
                    public boolean isValid() {
                        return false;
                    }

                    @Override
                    public void invalidate() {
                    }

                    @Override
                    public String[] getValueNames() {
                        return null;
                    }

                    @Override
                    public Object getValue(String name) {
                        return null;
                    }

                    @Override
                    public SSLSessionContext getSessionContext() {
                        return null;
                    }

                    @Override
                    public String getProtocol() {
                        return null;
                    }

                    @Override
                    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
                        return null;
                    }

                    @Override
                    public int getPeerPort() {
                        return 0;
                    }

                    @Override
                    public String getPeerHost() {
                        return null;
                    }

                    @Override
                    public java.security.cert.Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
                        return peerCerts;
                    }

                    @Override
                    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
                        return null;
                    }

                    @Override
                    public int getPacketBufferSize() {
                        return 0;
                    }

                    @Override
                    public Principal getLocalPrincipal() {
                        return null;
                    }

                    @Override
                    public java.security.cert.Certificate[] getLocalCertificates() {
                        return null;
                    }

                    @Override
                    public long getLastAccessedTime() {
                        return 0L;
                    }

                    @Override
                    public byte[] getId() {
                        return null;
                    }

                    @Override
                    public long getCreationTime() {
                        return 0L;
                    }

                    @Override
                    public String getCipherSuite() {
                        return null;
                    }

                    @Override
                    public int getApplicationBufferSize() {
                        return 0;
                    }
                };
            }

            @Override
            public String[] getSupportedCipherSuites() {
                return null;
            }

            @Override
            public String[] getSupportedProtocols() {
                return null;
            }

            @Override
            public boolean getUseClientMode() {
                return false;
            }

            @Override
            public boolean getWantClientAuth() {
                return false;
            }

            @Override
            public void removeHandshakeCompletedListener(HandshakeCompletedListener arg0) {
            }

            @Override
            public void setEnableSessionCreation(boolean arg0) {
            }

            @Override
            public void setEnabledCipherSuites(String[] arg0) {
            }

            @Override
            public void setEnabledProtocols(String[] arg0) {
            }

            @Override
            public void setNeedClientAuth(boolean arg0) {
            }

            @Override
            public void setUseClientMode(boolean arg0) {
            }

            @Override
            public void setWantClientAuth(boolean arg0) {
            }

            @Override
            public void startHandshake() throws IOException {
                DefaultTlsClient tlsClient = new DefaultTlsClient(){

                    @Override
                    public TlsAuthentication getAuthentication() throws IOException {
                        return new TlsAuthentication(){

                            @Override
                            public void notifyServerCertificate(com.manageengine.org.bouncycastle.crypto.tls.Certificate serverCerts) throws IOException {
                                try {
                                    CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                                    LinkedList<java.security.cert.Certificate> certs = new LinkedList<java.security.cert.Certificate>();
                                    for (Certificate cert : serverCerts.getCertificateList()) {
                                        certs.add(certFactory.generateCertificate(new ByteArrayInputStream(cert.getEncoded())));
                                    }
                                    1.access$002(this, certs.toArray(new java.security.cert.Certificate[0]));
                                }
                                catch (CertificateException e) {
                                    throw new IOException("Error while caching certificate.", e);
                                }
                            }

                            @Override
                            public TlsCredentials getClientCredentials(CertificateRequest arg0) throws IOException {
                                return null;
                            }
                        };
                    }
                };
                tlsClientProtocol.connect(tlsClient);
            }

            static /* synthetic */ java.security.cert.Certificate[] access$002(1 x0, java.security.cert.Certificate[] x1) {
                x0.peerCerts = x1;
                return x1;
            }
        };
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return null;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return null;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return null;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return null;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return null;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return null;
    }
}

