/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.config.WebSequenceConfig;
import com.manageengine.apminsight.agent.logging.AgentLogger;
import com.manageengine.apminsight.agent.logging.LoggingConstants;
import com.manageengine.apminsight.agent.smart.SmartSampler;
import java.util.Map;

public abstract class AbstractSequenceConfig
implements LoggingConstants,
JavaAgentConstants {
    protected boolean isTrackingEnabled = true;
    public int sequenceDropThreshold = 0;
    protected int trackerDropThreshold;
    protected short samplingFactor;
    protected boolean isTraceEnabled;
    protected float traceThreshold;
    protected boolean traceDuplicate = TRANSACTION_TRACE_DUPLICATE_DV;
    protected boolean isTransactionCpuTimeEnabled;
    protected boolean isTransactionMemoryAllocEnabled;
    protected int traceAfterExternalComponentCount;
    protected AgentLogger logger = JavaAgent.logger;

    public AbstractSequenceConfig(Map<String, Object> agentConfig) {
        this.trackerDropThreshold = this instanceof WebSequenceConfig ? 10 : 50;
        this.samplingFactor = this instanceof WebSequenceConfig ? SAMPLING_FACTOR_DV : (short)1;
        this.isTraceEnabled = this instanceof WebSequenceConfig ? TRANSACTION_TRACE_ENABLED_DV : BG_SEQUENCE_TRACE_ENABLED_DV;
        this.traceThreshold = this instanceof WebSequenceConfig ? TRANSACTION_TRACE_THRESHOLD_DV.floatValue() : 5.0f;
        this.isTransactionCpuTimeEnabled = this instanceof WebSequenceConfig ? WEBTRANS_CPU_TIME_ENABLED_DV : BG_SEQUENCE_CPU_TIME_ENABLED_DV;
        this.isTransactionMemoryAllocEnabled = this instanceof WebSequenceConfig ? WEBTRANS_MEMORY_ALLOC_ENABLED_DV : BG_SEQUENCE_MEMORY_ALLOC_ENABLED_DV;
        this.traceAfterExternalComponentCount = this instanceof WebSequenceConfig ? 30 : 40;
    }

    protected abstract void init(Map<String, Object> var1);

    public void reInitialize(Map<String, Object> agentConfig) {
        this.init(agentConfig);
    }

    public boolean isTrackingEnabled() {
        return this.isTrackingEnabled;
    }

    public int getSequenceDropThreshold() {
        return this.sequenceDropThreshold;
    }

    public int getTrackerDropTreshold() {
        return this.trackerDropThreshold;
    }

    public short getSamplingFactor() {
        return (short)(this.samplingFactor * SmartSampler.getSamplingMultiplier());
    }

    public boolean isSeqTraceEnabled() {
        return this.isTraceEnabled;
    }

    public float getSeqTraceThreshold() {
        return this.traceThreshold * 1000.0f;
    }

    public boolean isTransactionCpuTimeEnabled() {
        return this.isTransactionCpuTimeEnabled;
    }

    public boolean isTransactionMemoryAllocEnabled() {
        return this.isTransactionMemoryAllocEnabled;
    }

    public int getTraceAfterExternalComponentCount() {
        return this.traceAfterExternalComponentCount;
    }

    public abstract boolean canTraceDuplicate();
}

