/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.context;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextNameChanger;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ContextInfoManager {
    private static ContextInfoManager contextInfoManager;
    private Map<String, ContextInfo> contextInfoMapping = new HashMap<String, ContextInfo>();

    private ContextInfoManager() {
    }

    public static ContextInfoManager getInstance() {
        if (contextInfoManager == null) {
            contextInfoManager = new ContextInfoManager();
        }
        return contextInfoManager;
    }

    public ContextInfo getContextInfoIfPresent(String contextName) {
        if ((contextName = ContextNameChanger.getContextName(contextName)) == null) {
            return null;
        }
        return this.contextInfoMapping.get(contextName);
    }

    public ContextInfo getContextInfoOrDefault(String contextName) {
        contextName = (contextName = ContextNameChanger.getContextName(contextName)) == null ? "" : contextName;
        return this.contextInfoMapping.containsKey(contextName) ? this.contextInfoMapping.get(contextName) : this.getDefaultContextInfo();
    }

    public ContextInfo createContextInfoIfNotExists(String name, String instanceID, String instanceState, Map config) throws RuntimeException {
        ContextInfo contextInfo = this.contextInfoMapping.get(name = ContextNameChanger.getContextName(name));
        if (contextInfo != null) {
            return contextInfo;
        }
        if (name == null) {
            String msg = "Context Name cannot be null. Aborting context creation";
            JavaAgent.logger.warn(msg);
            throw new RuntimeException(msg);
        }
        contextInfo = new ContextInfo(name, instanceID, instanceState, config);
        this.contextInfoMapping.put(name, contextInfo);
        JavaAgent.logger.info("New ContextInfo created for context: '" + name + "'");
        return contextInfo;
    }

    public ContextInfo getDefaultContextInfo() throws RuntimeException {
        if (this.contextInfoMapping.containsKey("")) {
            return this.contextInfoMapping.get("");
        }
        throw new RuntimeException("Default context not yet initialized.");
    }

    public Collection<ContextInfo> getAllContexts() {
        return this.contextInfoMapping.values();
    }

    public void updateAllContextsConfig(Map agentConfig) {
        for (ContextInfo context : this.contextInfoMapping.values()) {
            try {
                context.updateConfig(agentConfig);
            }
            catch (Exception e) {
                JavaAgent.logger.log(Level.WARN, "Unable to update config for context " + context.getContextName(), e);
            }
        }
    }
}

