/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.installer;

import com.manageengine.apminsight.agent.installer.AgentInstaller;
import com.manageengine.apminsight.agent.installer.JBossASInstaller;
import com.manageengine.apminsight.agent.installer.JBossEAPInstaller;
import com.manageengine.apminsight.agent.installer.JettyInstaller;
import com.manageengine.apminsight.agent.installer.TomcatInstaller;

public enum AppServer {
    TOMCAT("TOMCAT"){

        @Override
        public AgentInstaller getInstaller(String serverPath) {
            return new TomcatInstaller(serverPath);
        }
    }
    ,
    JBOSS_AS("JBOSS"){

        @Override
        public AgentInstaller getInstaller(String serverPath) {
            return new JBossASInstaller(serverPath);
        }
    }
    ,
    JBOSS_EAP("JBOSS"){

        @Override
        public AgentInstaller getInstaller(String serverPath) {
            return new JBossEAPInstaller(serverPath);
        }
    }
    ,
    WILDFLY("WILDFLY"){

        @Override
        public AgentInstaller getInstaller(String serverPath) {
            return new JBossEAPInstaller(serverPath);
        }
    }
    ,
    JETTY("JETTY"){

        @Override
        public AgentInstaller getInstaller(String serverPath) {
            return new JettyInstaller(serverPath);
        }
    }
    ,
    UNKNOWN("Unknown");

    private final String servername;

    private AppServer(String name) {
        this.servername = name;
    }

    public String getServerName() {
        return this.servername;
    }

    public AgentInstaller getInstaller(String serverPath) {
        return null;
    }
}

