/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.installer;

import com.manageengine.apminsight.agent.installer.AgentInstaller;
import java.io.IOException;

public final class JBossASInstaller
extends AgentInstaller {
    private String agentLocation;

    public JBossASInstaller(String serverDir) {
        super(serverDir + (isWindowsOS ? "/bin/run.bat" : "/bin/run.sh"));
    }

    @Override
    public boolean installAgent(String agentPath) throws IOException {
        this.agentLocation = agentPath;
        if (this.prepareForInstallation()) {
            return isWindowsOS ? this.addArgumentAfterMarker(this.getMarker(), this.getAgentArgument()) : this.addArgumentBeforeMarker(this.getMarker(), this.getAgentArgument());
        }
        return false;
    }

    @Override
    protected String getMarker() {
        return isWindowsOS ? "rem Setup JBoss specific properties" : "# Setup JBOSS_HOME";
    }

    @Override
    protected String getAgentArgument() {
        String agentSwitch = "-javaagent:" + this.agentLocation + "/apminsight-javaagent.jar";
        return LINE_SEPARATOR + (isWindowsOS ? "set JAVA_OPTS=%JAVA_OPTS% " + agentSwitch : "JAVA_OPTS=\"\\$JAVA_OPTS " + agentSwitch + "\"") + LINE_SEPARATOR;
    }
}

