/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.installer;

import com.manageengine.apminsight.agent.installer.AgentInstaller;
import java.io.IOException;

public final class JBossEAPInstaller
extends AgentInstaller {
    private String agentLocation;

    public JBossEAPInstaller(String serverDir) {
        super(serverDir + (isWindowsOS ? "/bin/standalone.conf.bat" : "/bin/standalone.sh"));
    }

    @Override
    public boolean installAgent(String agentPath) throws IOException {
        this.agentLocation = agentPath;
        if (this.prepareForInstallation()) {
            String additionalMarker = "-Djboss.modules.system.pkgs=org.jboss.byteman";
            String additionalConfig = "-Djboss.modules.system.pkgs=org.jboss.byteman,com.manageengine";
            String agentArgument = this.getAgentArgument();
            if (this.locateMarker(additionalMarker)) {
                if (!this.addArgumentReplacingMarker(additionalMarker, additionalConfig)) {
                    return false;
                }
            } else {
                agentArgument = agentArgument + (isWindowsOS ? "set JAVA_OPTS=%JAVA_OPTS% " + additionalConfig : "JAVA_OPTS=\"\\$JAVA_OPTS " + additionalConfig + "\"") + LINE_SEPARATOR;
            }
            return this.addArgumentBeforeMarker(this.getMarker(), agentArgument);
        }
        return false;
    }

    @Override
    protected String getMarker() {
        return isWindowsOS ? ":JAVA_OPTS_SET" : "# Setup the JVM";
    }

    @Override
    protected String getAgentArgument() {
        String agentSwitch = "-javaagent:" + this.agentLocation + "/apminsight-javaagent.jar";
        return LINE_SEPARATOR + (isWindowsOS ? "set JAVA_OPTS=%JAVA_OPTS% " + agentSwitch : "JAVA_OPTS=\"\\$JAVA_OPTS " + agentSwitch + "\"") + LINE_SEPARATOR;
    }
}

