/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.installer;

import com.manageengine.apminsight.agent.installer.AgentInstaller;
import java.io.IOException;

public final class TomcatInstaller
extends AgentInstaller {
    private String agentLocation;

    public TomcatInstaller(String serverDir) {
        super(serverDir + (isWindowsOS ? "/bin/catalina.bat" : "/bin/catalina.sh"));
    }

    @Override
    public boolean installAgent(String agentPath) throws IOException {
        this.agentLocation = agentPath;
        if (this.prepareForInstallation()) {
            return this.addArgumentBeforeMarker(this.getMarker(), this.getAgentArgument());
        }
        return false;
    }

    @Override
    protected String getMarker() {
        return isWindowsOS ? "rem Guess CATALINA_HOME if not defined" : "# Get standard environment variables";
    }

    @Override
    protected String getAgentArgument() {
        String agentSwitch = "-javaagent:" + this.agentLocation + "/apminsight-javaagent.jar";
        return LINE_SEPARATOR + (isWindowsOS ? "set JAVA_OPTS=%JAVA_OPTS% " + agentSwitch : "JAVA_OPTS=\"\\$JAVA_OPTS " + agentSwitch + "\"") + LINE_SEPARATOR;
    }
}

