/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.BasicMethodAdapter;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.apminsight.agent.smart.SmartPackageFilter;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.objectweb.asm.ClassVisitor;
import com.manageengine.org.objectweb.asm.MethodVisitor;
import java.util.List;

class BasicClassAdapter
extends ClassVisitor {
    private String className;
    private List<InterceptorDefinition> interceptors;
    private boolean isUserClass = false;

    public BasicClassAdapter(ClassVisitor cv, String className, Class<?> classBeingRedefined, List<InterceptorDefinition> bestMatchingInterceptors, List<InterceptorDefinition> otherMatchingInterceptors) {
        super(589824, cv);
        this.className = className;
        this.interceptors = bestMatchingInterceptors.size() > 0 ? bestMatchingInterceptors : otherMatchingInterceptors;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String description, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, description, signature, exceptions);
        if (name.matches("<(cl)?init>") || (access & 0x400) != 0) {
            return mv;
        }
        for (InterceptorDefinition interceptor : this.interceptors) {
            if (interceptor.interceptorName.matches("com.manageengine.+(Servlet.+|ActionInterceptor.+|SpringController.+|Filter.+|api.Apm.+)")) {
                this.isUserClass = true;
            }
            if (interceptor.excludeMethodMatcher != null && interceptor.excludeMethodMatcher.matches(name, description)) {
                return mv;
            }
            if (!interceptor.includeMethodMatcher.matches(name, description)) continue;
            JavaAgent.logger.log(Level.DEBUG, "Method 2b instrumented: {}.{}{}", this.className, name, description);
            BasicMethodAdapter ma = new BasicMethodAdapter(this, this.className, mv, access, name, description, interceptor);
            return ma;
        }
        return mv;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        if (this.isUserClass) {
            SmartPackageFilter.getInstance().addUserPackage(this.className);
        }
    }
}

