/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.InterceptorDefinitionFactory;
import com.manageengine.apminsight.agent.instrumentation.interceptor.AnnotationInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.InterceptorDefinitionIndex;
import com.manageengine.org.objectweb.asm.Type;
import java.lang.annotation.Annotation;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClassRetransformationEngine {
    private boolean isClzRetransformationSupported = false;
    private Set<String> retransformIfEscaped = new HashSet<String>();
    private Instrumentation inst;
    public static Set<String> collectionMapClassesNames = null;

    public ClassRetransformationEngine(Instrumentation inst) {
        this.inst = inst;
        try {
            this.isClzRetransformationSupported = inst.isRetransformClassesSupported();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("", th);
        }
        JavaAgent.logger.info("ClassRetransformationEngine initialized. isClzRetransformationSupported: " + this.isClzRetransformationSupported);
    }

    public boolean retransformIfEscapedFromInstrumentation(String ... classNames) {
        if (this.isClzRetransformationSupported) {
            this.retransformIfEscaped.addAll(Arrays.asList(classNames));
            JavaAgent.logger.info("[ClassRetransformationEngine] add retransformIfEscapedFromInstrumentation list updated: " + this.retransformIfEscaped);
        }
        return this.isClzRetransformationSupported;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retransformEscaped() {
        Class[] tillNowLoadedClasses;
        if (!this.isClzRetransformationSupported) {
            return;
        }
        ArrayList<String> retransformIfEscaped = new ArrayList<String>(this.retransformIfEscaped);
        if (retransformIfEscaped.isEmpty()) {
            return;
        }
        ArrayList escapedClasses = new ArrayList(retransformIfEscaped.size());
        block5: for (Class c : tillNowLoadedClasses = this.inst.getAllLoadedClasses()) {
            for (int i = 0; i < retransformIfEscaped.size(); ++i) {
                String classRegEx = (String)retransformIfEscaped.get(i);
                String clzName = c.getName().replaceAll("\\.", "/");
                if (!clzName.matches(classRegEx)) continue;
                escapedClasses.add(c);
                continue block5;
            }
        }
        tillNowLoadedClasses = null;
        JavaAgent.logger.info("[ClassRetransformationEngine] classes escaped from instrumentation are: " + escapedClasses);
        try {
            this.retransform(escapedClasses);
            JavaAgent.logger.info("[ClassRetransformationEngine] successfully retransformed escaped classes.");
            Set<String> set = this.retransformIfEscaped;
            synchronized (set) {
                this.retransformIfEscaped.removeAll(retransformIfEscaped);
            }
        }
        catch (Throwable throwable) {
            JavaAgent.logger.warn("", throwable);
        }
    }

    public Set<String> getAllCollectionMapClasses() {
        Class[] tillNowLoadedClasses;
        if (collectionMapClassesNames != null) {
            return collectionMapClassesNames;
        }
        collectionMapClassesNames = new HashSet<String>();
        for (Class clazz : tillNowLoadedClasses = this.inst.getAllLoadedClasses()) {
            if (!clazz.toString().contains("class java.util.") || clazz.isInterface() || !Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz)) continue;
            collectionMapClassesNames.add(clazz.getName().replaceAll("\\.", "/"));
        }
        return collectionMapClassesNames;
    }

    private void retransform(List<Class<?>> classes) throws Exception {
        if (classes.isEmpty()) {
            return;
        }
        this.retransform(classes.toArray(new Class[classes.size()]));
    }

    public void retransformAllClasses() throws Exception {
        JavaAgent.logger.info("[ClassRetransformationEngine] Retransformation of all classes initiated.");
        Class[] clzz = this.inst.getAllLoadedClasses();
        ArrayList retransformClasses = new ArrayList();
        List<InterceptorDefinition> annotationInterceptors = InterceptorDefinitionFactory.getInstance().getAnnotationInterceptors();
        block0: for (Class clz : clzz) {
            if (!this.inst.isModifiableClass(clz)) continue;
            if (!InterceptorDefinitionIndex.getInstance().lookup(clz.getName().replace('.', '/'), clz.getSuperclass() != null ? clz.getSuperclass().getName().replace('.', '/') : null, this.getInterfaceNames(clz)).isEmpty()) {
                retransformClasses.add(clz);
                continue;
            }
            for (Annotation annotation : clz.getAnnotations()) {
                for (InterceptorDefinition inDef : annotationInterceptors) {
                    if (!((AnnotationInterceptorDefinition)inDef).annotationMatcher.matches(Type.getDescriptor(annotation.getClass()))) continue;
                    retransformClasses.add(clz);
                    break;
                }
                if (retransformClasses.contains(clz)) continue block0;
            }
        }
        this.retransform(retransformClasses);
        JavaAgent.logger.info("[ClassRetransformationEngine] Retransformation of all classes completed.");
    }

    private String[] getInterfaceNames(Class<?> clz) {
        Class<?>[] interfaces = clz.getInterfaces();
        String[] names = new String[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            names[i] = interfaces[i].getName().replace('.', '/');
        }
        return names;
    }

    private void retransform(Class<?>[] classes) throws Exception {
        if (!this.isClzRetransformationSupported || classes == null || classes.length == 0) {
            return;
        }
        int classesCount = classes.length;
        JavaAgent.logger.info("[ClassRetransformationEngine] Initiating retransform of classes. Count: " + classesCount);
        int limit = 500;
        long starttime = System.currentTimeMillis();
        int startIndex = 0;
        while (startIndex < classesCount) {
            int endIndex = startIndex + limit > classesCount ? classesCount : startIndex + limit;
            try {
                Class<?>[] retransformClassesBatch = Arrays.copyOfRange(classes, startIndex, endIndex);
                this.inst.retransformClasses(retransformClassesBatch);
                Thread.sleep(100L);
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("Error occurred during retransform. Exception: " + th.getMessage() + " Type: " + th.getClass().getSimpleName());
            }
            startIndex = endIndex;
        }
        JavaAgent.logger.debug("[ClassRetransformationEngine] Time taken for retransforming classes: " + (System.currentTimeMillis() - starttime) + "ms");
    }

    public void addClassesForMemoryLeakDetection() {
        Set<String> collectionClasses = this.getAllCollectionMapClasses();
        String[] clazzes = collectionClasses.toArray(new String[collectionClasses.size()]);
        InterceptorDefinitionFactory.getInstance().addClassesToInterceptorDefMap();
        this.retransformIfEscapedFromInstrumentation(clazzes);
        this.retransformEscaped();
    }

    public void removeClassesForMemoryLeakDetection() {
        Set<String> collectionClasses = this.getAllCollectionMapClasses();
        String[] clazzes = collectionClasses.toArray(new String[collectionClasses.size()]);
        InterceptorDefinitionFactory.getInstance().removeClassesFromInterceptorDefMap();
        this.retransformIfEscapedFromInstrumentation(clazzes);
        this.retransformEscaped();
    }
}

