/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation;

import com.manageengine.apminsight.agent.JavaAgent;
import java.util.regex.Pattern;

public class InstrumentationFilter {
    private static Pattern packageExclusionPattern;

    public static void initialize() {
        String[] packageFilters = new String[]{"javax/.*", "jdk/.*", "java/(?!(net|util)).*", "sun/(?!net).*", "com/google/inject/.*", "org/w3c/dom/.*", "org/xml/sax/.*", "com/sun/(?!net).*", "org/jboss/.*", "org/apache/jasper/.*", "com/manageengine/apminsight/agent.*", "com/manageengine/org/.*"};
        StringBuilder sb = new StringBuilder();
        for (String pkgName : packageFilters) {
            sb.append(pkgName).append("|");
        }
        packageExclusionPattern = Pattern.compile(sb.toString());
        JavaAgent.logger.info("Package exclusion pattern to be used: " + packageExclusionPattern.pattern());
    }

    public static void updateExclusionPattern(String excludePackages) {
        try {
            excludePackages = excludePackages.replaceAll("\\s", "").replaceAll(",", "|");
            packageExclusionPattern = Pattern.compile(packageExclusionPattern.pattern() + "|" + excludePackages);
            JavaAgent.logger.info("Package exclusion pattern updated: " + packageExclusionPattern.pattern());
        }
        catch (Exception e) {
            JavaAgent.logger.warn("Error updating exclusion pattern, reverting to previous pattern. Exception: " + e.getMessage());
        }
    }

    public static boolean isExcludedPackage(String className) {
        return className.matches(packageExclusionPattern.pattern());
    }

    static {
        InstrumentationFilter.initialize();
    }
}

