/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class PointcutPropertiesPool<K extends PointcutProperties> {
    private final Map<K, K> pool;
    private AtomicInteger currentCapacity = new AtomicInteger(0);
    private final int maxCapacity;
    private String poolName;

    public PointcutPropertiesPool(int maxCapacity, String poolName) {
        this.maxCapacity = maxCapacity;
        this.poolName = poolName;
        float loadFactor = 0.75f;
        int bucketResizePreventValue = (int)((double)((float)maxCapacity / loadFactor) + 0.5);
        this.pool = new ConcurrentHashMap<K, K>(++bucketResizePreventValue, loadFactor, 16);
    }

    public K add(K pointcutProperties) {
        if (this.currentCapacity.intValue() < this.maxCapacity) {
            this.currentCapacity.incrementAndGet();
            return (K)((PointcutProperties)this.pool.put(pointcutProperties, pointcutProperties));
        }
        if (this.currentCapacity.intValue() == this.maxCapacity) {
            JavaAgent.logger.log(Level.WARN, "{} overflow({}/{}). {} not assigned to pool. Current pool data: {}", this.poolName, this.currentCapacity.intValue(), this.maxCapacity, pointcutProperties, this.pool);
            this.currentCapacity.incrementAndGet();
        }
        return null;
    }

    public K get(Object k1, Object k2) {
        return (K)((PointcutProperties)this.pool.get(new Holder(k1, k2)));
    }

    public K get(Object k1, Object k2, Object k3) {
        return (K)((PointcutProperties)this.pool.get(new Holder(k1, k2, k3)));
    }

    public K get(Object ... keyIdentifiers) {
        return (K)((PointcutProperties)this.pool.get(new Holder(keyIdentifiers)));
    }

    static class Holder {
        int hashCode;

        public Holder(Object o1, Object o2) {
            this.hashCode = o1.hashCode() ^ o2.hashCode();
        }

        public Holder(Object o1, Object o2, Object o3) {
            this.hashCode = o1.hashCode() ^ o2.hashCode() ^ o3.hashCode();
        }

        public Holder(Object ... objects) {
            for (Object o : objects) {
                this.hashCode ^= o.hashCode();
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            return this.hashCode == o.hashCode();
        }
    }
}

