/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.api;

import com.manageengine.apminsight.agent.api.ApmRootTracker;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.instrumentation.interceptor.AnnotationInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.api.ApmTrackerInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnnotationMatcher;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.api.ApiAnnotationTracker;
import com.manageengine.org.objectweb.asm.Type;
import java.util.regex.Matcher;

public class ApmRootTrackerInterceptorDefinition
extends AnnotationInterceptorDefinition {
    private static final String APM_ROOT_TRACKER_TYPE_DESC = Type.getDescriptor(ApmRootTracker.class);

    public ApmRootTrackerInterceptorDefinition() {
        super(ApmRootTrackerInterceptorDefinition.class.getName(), new AnnotationMatcher(APM_ROOT_TRACKER_TYPE_DESC));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args, String annotationAttributes) {
        String[] attributes;
        String componentName = Component.APP_CODE.toString();
        for (String attrib : attributes = annotationAttributes.split(";")) {
            if (attrib.startsWith("name")) {
                String name = attrib.substring(attrib.indexOf(61) + 1);
                Matcher m = ApmTrackerInterceptorDefinition.NAME_ARG_PATTERN.matcher(name);
                while (m.find()) {
                    Object replaceStr = args[Integer.parseInt(m.group(1)) - 1];
                    replaceStr = replaceStr == null ? "" : replaceStr;
                    name = m.replaceFirst(replaceStr.toString());
                    m = ApmTrackerInterceptorDefinition.NAME_ARG_PATTERN.matcher(name);
                }
                className = name + " - " + className;
                continue;
            }
            if (!attrib.startsWith("component")) continue;
            componentName = attrib.substring(attrib.indexOf(61) + 1);
        }
        final Component component = Component.get(componentName);
        BasicPointcutProperties p = new BasicPointcutProperties(className, methodName){

            @Override
            public Component getComponent() {
                return component;
            }
        };
        return new ApiAnnotationTracker(p, thisObj, args, annotationAttributes);
    }
}

