/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.api;

import com.manageengine.apminsight.agent.api.ApmTracker;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.instrumentation.interceptor.AnnotationInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnnotationMatcher;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.org.objectweb.asm.Type;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApmTrackerInterceptorDefinition
extends AnnotationInterceptorDefinition {
    private static final String APM_TRACKER_TYPE_DESC = Type.getDescriptor(ApmTracker.class);
    protected static final Pattern NAME_ARG_PATTERN = Pattern.compile("\\$(\\d+)");

    public ApmTrackerInterceptorDefinition() {
        super(ApmTrackerInterceptorDefinition.class.getName(), new AnnotationMatcher(APM_TRACKER_TYPE_DESC));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args, String annotationAttributes) {
        String[] attributes;
        String componentName = Component.APP_CODE.toString();
        for (String attrib : attributes = annotationAttributes.split(";")) {
            if (attrib.startsWith("name")) {
                String name = attrib.substring(attrib.indexOf(61) + 1);
                Matcher m = NAME_ARG_PATTERN.matcher(name);
                while (m.find()) {
                    Object replaceStr = args[Integer.parseInt(m.group(1)) - 1];
                    replaceStr = replaceStr == null ? "" : replaceStr;
                    name = m.replaceFirst(replaceStr.toString());
                    m = NAME_ARG_PATTERN.matcher(name);
                }
                className = name + " - " + className;
                continue;
            }
            if (!attrib.startsWith("component")) continue;
            componentName = attrib.substring(attrib.indexOf(61) + 1);
        }
        final Component component = Component.get(componentName);
        return new DefaultTracker(new BasicPointcutProperties(className, methodName){

            @Override
            public Component getComponent() {
                return component;
            }
        }, thisObj, args);
    }
}

