/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.cache;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.cache.CachedFrameworkTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Method;

public class MemcachedInterceptorDefinition
extends TracingInterceptorDefinition {
    private static final String METHOD_DESCRIPTION = "/.*/";
    private static final String METHOD_GETCONNECTION = "getConnection";
    private static final String METHOD_ADDOPERATION = "addOperation";

    public MemcachedInterceptorDefinition() {
        super(MemcachedInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassMatcher("com/danga/MemCached/MemCachedClient"), new ClassMatcher("net/spy/memcached/MemcachedClient"), new ClassMatcher("com/schooner/MemCached/SchoonerSockIOPool"), new ClassMatcher("net/spy/memcached/MemcachedConnection")), null, new ManyMethodMatcher(new MethodMatcher("get", METHOD_DESCRIPTION), new MethodMatcher("set", METHOD_DESCRIPTION), new MethodMatcher("add", METHOD_DESCRIPTION), new MethodMatcher("incr", METHOD_DESCRIPTION), new MethodMatcher("decr", METHOD_DESCRIPTION), new MethodMatcher("delete", METHOD_DESCRIPTION), new MethodMatcher("replace", METHOD_DESCRIPTION), new MethodMatcher("getBulk", METHOD_DESCRIPTION), new MethodMatcher("getMulti", METHOD_DESCRIPTION), new MethodMatcher(METHOD_GETCONNECTION, "(Ljava/lang/String;)Lcom/schooner/MemCached/SchoonerSockIO;"), new MethodMatcher(METHOD_ADDOPERATION, "(Lnet/spy/memcached/MemcachedNode;Lnet/spy/memcached/ops/Operation;)V")));
    }

    @Override
    public Tracker getTracker(String interceptedClzName, String interceptedMethName, Object thisObj, Object[] args) {
        if (interceptedClzName.matches("com/schooner/MemCached/SchoonerSockIOPool|net/spy/memcached/MemcachedConnection") && JavaAgentConfig.captureHostDetails) {
            Tracker currOpenTracker = SequenceSpace.SEQUENCE_BOOK.get().getCurrentOpenTracker();
            if (currOpenTracker instanceof CachedFrameworkTracker) {
                ((CachedFrameworkTracker)currOpenTracker).setServerAddr(this.extractServerAddress(args[0]));
            }
            return null;
        }
        BasicPointcutProperties p = new BasicPointcutProperties(interceptedClzName, interceptedMethName){

            @Override
            public Component getComponent() {
                return Component.MEMCACHED;
            }
        };
        return new CachedFrameworkTracker(p, thisObj, args);
    }

    private String extractServerAddress(Object serverInfoObj) {
        String address = null;
        if (serverInfoObj instanceof String) {
            address = serverInfoObj.toString();
        } else if (serverInfoObj.getClass().getName().contains("spy")) {
            try {
                Method method = serverInfoObj.getClass().getMethod("getSocketAddress", new Class[0]);
                address = method.invoke(serverInfoObj, new Object[0]).toString();
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "[MemcachedTracker] Unable to extract memcached server address. Exception: " + th.getMessage());
            }
        }
        return address;
    }
}

