/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.cache;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.cache.CachedFrameworkTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class RedisInterceptorDefinition
extends TracingInterceptorDefinition {
    public static final String[] SET_METHOD_DESC = new String[]{"(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;J)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "(Ljava/lang/String;[B)V", "(Ljava/lang/String;Ljava/lang/String;)Lredis/clients/jedis/Response;"};
    public static final String[] GET_METHOD_DESC = new String[]{"(Ljava/lang/String;)[B", "(Ljava/lang/String;)Ljava/lang/String;", "(Ljava/lang/String;)Lredis/clients/jedis/Response;"};
    public static final String[] DEL_METHOD_DESC = new String[]{"(Ljava/lang/String;)Z", "(Ljava/lang/String;)Ljava/lang/Long;", "([Ljava/lang/String;)Ljava/lang/Long;", "(Ljava/lang/String;)Lredis/clients/jedis/Response;", "([Ljava/lang/String;)Lredis/clients/jedis/Response;"};
    public static final String[] INCR_DECR_METHOD_DESC = new String[]{"(Ljava/lang/String;)Ljava/lang/Long;", "(Ljava/lang/String;)J", "(Ljava/lang/String;)Lredis/clients/jedis/Response;"};
    public static final String JREDIS_BY_METHOD_DESC = "(Ljava/lang/String;I)J";
    public static final String[] JEDIS_BY_METHOD_DESC = new String[]{"(Ljava/lang/String;J)Ljava/lang/Long;", "(Ljava/lang/String;J)Lredis/clients/jedis/Response;"};

    public RedisInterceptorDefinition() {
        super(RedisInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassMatcher("redis/clients/jedis/Jedis"), new ClassMatcher("redis/clients/jedis/Pipeline"), new InterfaceTypeMatcher("org/jredis/JRedis"), new ClassMatcher("redis/clients/jedis/BinaryClient"), new InterfaceTypeMatcher("org/jredis/connector/Connection")), null, new ManyMethodMatcher(new MethodMatcher("get", GET_METHOD_DESC), new MethodMatcher("set", SET_METHOD_DESC), new MethodMatcher("del", DEL_METHOD_DESC), new MethodMatcher("incr", INCR_DECR_METHOD_DESC), new MethodMatcher("decr", INCR_DECR_METHOD_DESC), new MethodMatcher("incrby", JREDIS_BY_METHOD_DESC), new MethodMatcher("decrby", JREDIS_BY_METHOD_DESC), new MethodMatcher("incrBy", JEDIS_BY_METHOD_DESC), new MethodMatcher("decrBy", JEDIS_BY_METHOD_DESC), new MethodMatcher("mget", new String[]{"([Ljava/lang/String;)Ljava/util/List;", "([Ljava/lang/String;)Lredis/clients/jedis/Response;"}), new MethodMatcher("mset", new String[]{"([Ljava/lang/String;)Ljava/lang/String;", "([Ljava/lang/String;)Lredis/clients/jedis/Response;"}), new MethodMatcher("sync", "()V"), new MethodMatcher("syncAndReturnAll", "()Ljava/util/List;"), new MethodMatcher("hget", new String[]{"(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "(Ljava/lang/String;Ljava/lang/String;)Lredis/clients/jedis/Response;"}), new MethodMatcher("hgetAll", new String[]{"(Ljava/lang/String;)Ljava/util/Map;", "(Ljava/lang/String;)Lredis/clients/jedis/Response;"}), new MethodMatcher("hset", new String[]{"(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Long;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Lredis/clients/jedis/Response;", "(Ljava/lang/String;Ljava/util/Map;)Lredis/clients/jedis/Response;"}), new MethodMatcher("hdel", new String[]{"(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/Long;", "(Ljava/lang/String;[Ljava/lang/String;)Lredis/clients/jedis/Response;"}), new MethodMatcher("hincrBy", new String[]{"(Ljava/lang/String;Ljava/lang/String;J)Ljava/lang/Long;", "(Ljava/lang/String;Ljava/lang/String;J)Lredis/clients/jedis/Response;"}), new MethodMatcher("hmset", new String[]{"(Ljava/lang/String;Ljava/util/Map;)Ljava/lang/String;", "(Ljava/lang/String;Ljava/util/Map;)Lredis/clients/jedis/Response;"}), new MethodMatcher("smembers", new String[]{"(Ljava/lang/String;)Ljava/util/Set;", "(Ljava/lang/String;)Lredis/clients/jedis/Response;"}), new MethodMatcher("connect", "()V"), new MethodMatcher("serviceRequest", "(Lorg/jredis/protocol/Command;[[B)Lorg/jredis/protocol/Response;")));
    }

    @Override
    public Tracker getTracker(String interceptedClzName, String interceptedMethName, Object thisObj, Object[] args) {
        if (interceptedMethName.matches("connect|serviceRequest") && JavaAgentConfig.captureHostDetails) {
            Tracker openTracker = SequenceSpace.SEQUENCE_BOOK.get().getCurrentOpenTracker();
            if (openTracker instanceof CachedFrameworkTracker) {
                String address = this.extractServerAddress(thisObj);
                ((CachedFrameworkTracker)openTracker).setServerAddr(address);
            }
            return null;
        }
        BasicPointcutProperties p = new BasicPointcutProperties(interceptedClzName, interceptedMethName){

            @Override
            public Component getComponent() {
                return Component.REDIS;
            }
        };
        return new CachedFrameworkTracker(p, thisObj, args);
    }

    private String extractServerAddress(Object serverInfoObj) {
        String address = null;
        try {
            String clzName = serverInfoObj.getClass().getName();
            if (clzName.contains("jedis")) {
                Method method = serverInfoObj.getClass().getMethod("getHost", new Class[0]);
                address = (String)method.invoke(serverInfoObj, new Object[0]);
                method = serverInfoObj.getClass().getMethod("getPort", new Class[0]);
                address = address + ":" + method.invoke(serverInfoObj, new Object[0]);
            } else if (clzName.contains("jredis")) {
                Class<?> clz = serverInfoObj.getClass().getClassLoader().loadClass("org.jredis.ri.alphazero.connection.ConnectionBase");
                Field field = clz.getDeclaredField("socketAddress");
                field.setAccessible(true);
                address = field.get(serverInfoObj).toString();
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[RedisTracker] Unable to extract redis server address. Exception: " + th.getMessage());
            address = null;
        }
        return address;
    }
}

