/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.cassandra;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.config.ApplicationConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;

public class CassandraAsyncInterceptorDefinition
extends TracingInterceptorDefinition {
    public CassandraAsyncInterceptorDefinition() {
        super(CassandraAsyncInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassTypeMatcher("com/datastax/driver/core/AbstractSession"), new ClassMatcher("com/google/common/util/concurrent/AbstractFuture")), null, new ManyMethodMatcher(new MethodMatcher("executeAsync", "(Lcom/datastax/driver/core/Statement;)Lcom/datastax/driver/core/ResultSetFuture;"), new MethodMatcher("set", "(Ljava/lang/Object;)Z"), new MethodMatcher("setException", "(Ljava/lang/Throwable;)Z")));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thizObj, Object[] args) {
        ApplicationConfig config = SequenceSpace.SEQUENCE_BOOK.get().getConfig();
        if (config == null || !config.captureSql) {
            return null;
        }
        if (methodName.equals("executeAsync")) {
            BasicPointcutProperties pointcutProperties = new BasicPointcutProperties(className, methodName){

                @Override
                public Component getComponent() {
                    return Component.CASSANDRA;
                }
            };
            return new CallerAsyncRootTracker(pointcutProperties, thizObj, args){

                @Override
                public void quit(int opCode, Object returnObj) {
                    super.quit(opCode, returnObj);
                    this.setCallbackObj(returnObj);
                    JavaAgent.logger.info("++++++++++++ Return Future id: " + returnObj.hashCode());
                }
            };
        }
        CallerAsyncRootTracker tracker = AsyncTracerService.getInstance().evictTracker(thizObj.hashCode());
        JavaAgent.logger.info("++++++++++++ Callback Future id: " + thizObj.hashCode());
        if (tracker != null) {
            if (methodName.equals("set")) {
                tracker.markCompleted(args[0]);
            } else {
                tracker.markFailed((Throwable)args[0]);
            }
        }
        return null;
    }
}

