/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.cassandra;

import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.config.ApplicationConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.cassandra.CassandraDatastax4xTracker;
import com.manageengine.apminsight.agent.trackers.cassandra.CassandraTracker;

public class CassandraInterceptorDefinition
extends TracingInterceptorDefinition {
    public CassandraInterceptorDefinition() {
        super(CassandraInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new InterfaceTypeMatcher("com/datastax/driver/core/Session"), new InterfaceTypeMatcher("com/datastax/oss/driver/api/core/session/Session")), null, new ManyMethodMatcher(new MethodMatcher("execute", "(Lcom/datastax/driver/core/Statement;)Lcom/datastax/driver/core/ResultSet;"), new MethodMatcher("execute", "(Lcom/datastax/oss/driver/api/core/cql/Statement;)Lcom/datastax/oss/driver/api/core/cql/ResultSet;")));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thizObj, Object[] args) {
        ApplicationConfig config = SequenceSpace.SEQUENCE_BOOK.get().getConfig();
        if (config == null || !config.captureSql) {
            return null;
        }
        BasicPointcutProperties pointcutProperties = new BasicPointcutProperties(className, methodName){

            @Override
            public Component getComponent() {
                return Component.CASSANDRA;
            }
        };
        if (className.contains("oss")) {
            return new CassandraDatastax4xTracker(pointcutProperties, thizObj, args);
        }
        return new CassandraTracker(pointcutProperties, thizObj, args);
    }
}

