/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.jaxrs;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.AnnotationInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnnotationMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyAnnotationMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.http.JaxRSRequestTracker;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class JaxRSInterceptorDefinition
extends AnnotationInterceptorDefinition {
    public JaxRSInterceptorDefinition() {
        super(JaxRSInterceptorDefinition.class.getName(), new AnyAnnotationMatcher(new AnnotationMatcher("Ljavax/ws/rs/Path;"), new AnnotationMatcher("Ljavax/ws/rs/GET;"), new AnnotationMatcher("Ljavax/ws/rs/POST;"), new AnnotationMatcher("Ljavax/ws/rs/PUT;"), new AnnotationMatcher("Ljavax/ws/rs/DELETE;"), new AnnotationMatcher("Ljavax/ws/rs/HEAD;"), new AnnotationMatcher("Ljavax/ws/rs/OPTIONS;")));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args, String annotations) {
        BasicPointcutProperties pointcut = new BasicPointcutProperties(className, methodName);
        if (SequenceSpace.SEQUENCE_BOOK.get().currentTrackersCount() == 0) {
            String seqName = this.constructRequestPath(thisObj, methodName, args, annotations);
            String httpMethod = this.getHttpMethod(thisObj, methodName, args);
            return new JaxRSRequestTracker((PointcutProperties)pointcut, seqName, httpMethod);
        }
        return new DefaultTracker(pointcut, thisObj, args);
    }

    private String getHttpMethod(Object thisObj, String methodName, Object[] args) {
        try {
            Annotation[] allAnnotations;
            Method method = this.getMethodObject(methodName, thisObj, args);
            for (Annotation annotation : allAnnotations = method.getAnnotations()) {
                String name = annotation.annotationType().getSimpleName();
                if (!name.matches("GET|POST|PUT|DELETE|HEAD|OPTIONS")) continue;
                return name;
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "[JAX-WS] Unable to determine the http method. Exception: " + e.getMessage());
        }
        return null;
    }

    private String constructRequestPath(Object thisObj, String methodName, Object[] args, String annotations) {
        String reqPath = null;
        if (!StringUtils.isEmptyString(annotations)) {
            reqPath = annotations.substring(annotations.indexOf(61) + 1);
        }
        try {
            String partPath = this.getAnnotationValue(thisObj, methodName, args);
            if (partPath != null && !partPath.equals(reqPath)) {
                reqPath = reqPath + (reqPath.endsWith("/") ? (partPath.startsWith("/") ? partPath.substring(1) : partPath) : (partPath.startsWith("/") ? partPath : "/" + partPath));
            }
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "[JAX-WS] Unable to get Path annotation value. Exception: " + e.getMessage(), e);
        }
        return reqPath;
    }

    private String getAnnotationValue(Object thisObj, String methodName, Object[] args) throws Exception {
        Class<?> pathClass;
        Method method = this.getMethodObject(methodName, thisObj, args);
        Object pathClassObj = method.getAnnotation(pathClass = thisObj.getClass().getClassLoader().loadClass("javax.ws.rs.Path"));
        if (pathClassObj != null) {
            Method value = pathClassObj.getClass().getDeclaredMethod("value", new Class[0]);
            return (String)value.invoke(pathClassObj, new Object[0]);
        }
        return null;
    }

    private Method getMethodObject(String methodName, Object thiz, Object[] args) throws Exception {
        Class[] types = new Class[args.length];
        int i = 0;
        for (Object arg : args) {
            types[i++] = arg.getClass();
        }
        return thiz.getClass().getMethod(methodName, types);
    }
}

