/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks;

import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.exception.ErrorRecord;
import com.manageengine.apminsight.agent.tracing.exception.ErrorThrowable;
import com.manageengine.apminsight.agent.tracing.exception.FatalLogRecord;
import com.manageengine.apminsight.agent.tracing.exception.WarningLogRecord;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractLoggerInterceptionDefinition
extends TracingInterceptorDefinition {
    protected static final String LOG_METHOD = "log";
    protected List<String> warningCategory;
    protected List<String> fatalCategory;

    public AbstractLoggerInterceptionDefinition(String interceptorName, ClassTypeMatcher classTypeMatcher, MethodMatcher excludeMethodMatcher, MethodMatcher includeMethodMatcher, String[] warningCategory, String[] fatalCategory) {
        super(interceptorName, classTypeMatcher, excludeMethodMatcher, includeMethodMatcher);
        this.warningCategory = warningCategory == null ? Collections.emptyList() : Arrays.asList(warningCategory);
        this.fatalCategory = fatalCategory == null ? Collections.emptyList() : Arrays.asList(fatalCategory);
    }

    private Throwable findExceptionObject(Object[] args) {
        for (Object obj : args) {
            if (obj == null || !(obj instanceof Throwable) || ((Throwable)obj).getClass().getName().matches(SequenceSpace.SEQUENCE_BOOK.get().getConfig().excludeExceptionsRegex)) continue;
            return (Throwable)obj;
        }
        return null;
    }

    protected ErrorRecord createLogRecord(String logMethod, long logTime, String userMessage, ErrorThrowable loggedThrowable) {
        if (this.warningCategory.contains(logMethod)) {
            return new WarningLogRecord(logTime, userMessage, loggedThrowable);
        }
        if (this.fatalCategory.contains(logMethod)) {
            return new FatalLogRecord(logTime, userMessage, loggedThrowable);
        }
        return null;
    }

    protected ErrorThrowable createLoggedThrowable(Object[] args) throws Exception {
        Throwable th;
        if (args.length > 1 && (th = this.findExceptionObject(args)) != null) {
            return new ErrorThrowable(th);
        }
        throw new Exception("Unable to find throwable object");
    }
}

