/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks.AbstractLoggerInterceptionDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.exception.ErrorRecord;
import com.manageengine.apminsight.agent.tracing.exception.ErrorThrowable;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.regex.Pattern;

public class Log4J2InterceptorDefinition
extends AbstractLoggerInterceptionDefinition {
    private static final Pattern LOG4J_LOG_METHOD_PRIORITY_PATTERN = Pattern.compile("^.*(warn|error|fatal).*$");

    public Log4J2InterceptorDefinition() {
        super(Log4J2InterceptorDefinition.class.getName(), new ClassMatcher(" org/apache/logging/log4j/spi/AbstractLogger"), null, new MethodMatcher("logIfEnabled", "\\(Ljava/lang/String;Lorg/apache/logging/log4j/Level;Lorg/apache/logging/log4j/Marker;L.+?;Ljava/lang/Throwable;\\)V"), new String[]{"warn"}, new String[]{"fatal", "error"});
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object thisObj, Object[] args) {
        long logTime = System.currentTimeMillis();
        if (SequenceSpace.SEQUENCE_BOOK.get().currentTrackersCount() == 0) {
            SequenceSpace.SEQUENCE_BOOK.remove();
            return null;
        }
        if (args == null || args.length == 0) {
            StringBuilder sb = new StringBuilder("[Log4j2InterceptorDefinition] ");
            sb.append(className);
            sb.append('.');
            sb.append(methodName);
            sb.append(" received zero arguments!");
            JavaAgent.logger.warn(sb.toString());
            return null;
        }
        try {
            String logLevel;
            String message = null;
            String string = logLevel = args.length > 1 ? args[1].toString().toLowerCase() : null;
            if (!LOG4J_LOG_METHOD_PRIORITY_PATTERN.matcher(logLevel).matches()) {
                return null;
            }
            message = args[args.length - 2].getClass().getName().startsWith("java") ? args[args.length - 2].toString() : null;
            ErrorThrowable loggedTh = this.createLoggedThrowable(args);
            ErrorRecord logRecord = this.createLogRecord(logLevel, logTime, message, loggedTh);
            SequenceSpace.SEQUENCE_BOOK.get().getLogRecordBag().add(logRecord);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("[Log4j2InterceptorDefinition] ");
            sb.append(className);
            sb.append('.');
            sb.append(methodName);
            sb.append(" unable to record the logging");
            JavaAgent.logger.log(Level.WARN, sb.toString(), e);
        }
        return null;
    }
}

