/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.loggingframeworks.AbstractLoggerInterceptionDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.sequence.SequenceSpace;
import com.manageengine.apminsight.agent.tracing.exception.ErrorRecord;
import com.manageengine.apminsight.agent.tracing.exception.ErrorThrowable;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.regex.Pattern;

public class Log4jInterceptorDefinition
extends AbstractLoggerInterceptionDefinition {
    private static final String LOG4J_LOG_METHOD_WARN = "warn";
    private static final String LOG4J_LOG_METHOD_ERROR = "error";
    private static final String LOG4J_LOG_METHOD_FATAL = "fatal";
    private static final Pattern LOG4J_LOG_METHOD_PRIORITY_PATTERN = Pattern.compile("^.*(warn|error|fatal).*$");
    private static final String LOG4J_LOG_METHOD_ARGS_OBJ = "(Ljava/lang/Object;)V";
    private static final String LOG4J_LOG_METHOD_ARGS_OBJ_THROWABLE = "(Ljava/lang/Object;Ljava/lang/Throwable;)V";

    public Log4jInterceptorDefinition() {
        super(Log4jInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new InterfaceTypeMatcher(" org/apache/commons/logging/Log"), new InterfaceTypeMatcher("org/apache/juli/logging/Log"), new ClassMatcher(" org/apache/log4j/Category"), new ClassTypeMatcher(" org/apache/log4j/Category"), new ClassTypeMatcher(" org/apache/log4j/Logger"), new ClassMatcher(" org/slf4j/impl/Log4jLoggerAdapter"), new ClassMatcher(" org/apache/logging/slf4j/Log4jLogger")), null, new ManyMethodMatcher(new MethodMatcher(LOG4J_LOG_METHOD_ERROR, LOG4J_LOG_METHOD_ARGS_OBJ_THROWABLE), new MethodMatcher(LOG4J_LOG_METHOD_ERROR, new String[]{"(Ljava/lang/String;Ljava/lang/Throwable;)V", "(Lorg/slf4j/Marker;Ljava/lang/String;Ljava/lang/Throwable;)V"}), new MethodMatcher(LOG4J_LOG_METHOD_FATAL, LOG4J_LOG_METHOD_ARGS_OBJ_THROWABLE), new MethodMatcher(LOG4J_LOG_METHOD_WARN, LOG4J_LOG_METHOD_ARGS_OBJ_THROWABLE), new MethodMatcher(LOG4J_LOG_METHOD_WARN, new String[]{"(Ljava/lang/String;Ljava/lang/Throwable;)V", "(Lorg/slf4j/Marker;Ljava/lang/String;Ljava/lang/Throwable;)V"}), new MethodMatcher("log", "(Lorg/apache/log4j/Priority;Ljava/lang/Object;Ljava/lang/Throwable;)V")), new String[]{LOG4J_LOG_METHOD_WARN}, new String[]{LOG4J_LOG_METHOD_ERROR, LOG4J_LOG_METHOD_FATAL});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tracker getTracker(String interceptedClz, String interceptedMethod, Object thisObj, Object[] args) {
        long logTime = System.currentTimeMillis();
        if (SequenceSpace.SEQUENCE_BOOK.get().currentTrackersCount() == 0) {
            SequenceSpace.SEQUENCE_BOOK.remove();
            return null;
        }
        if (args == null || args.length == 0) {
            StringBuilder sb = new StringBuilder("[Log4jInterceptorDefinition] ");
            sb.append(interceptedClz);
            sb.append('.');
            sb.append(interceptedMethod);
            sb.append(" received zero arguments!");
            JavaAgent.logger.warn(sb.toString());
            return null;
        }
        try {
            if (args[0] != null && args[0].getClass().getName().endsWith("Marker")) {
                args = new Object[]{args[1], args[2]};
            }
            String message = null;
            String logMethod = null;
            if ("log".equals(interceptedMethod)) {
                String log4JPriorityAsStr = args[0].toString().toLowerCase();
                if (!LOG4J_LOG_METHOD_PRIORITY_PATTERN.matcher(log4JPriorityAsStr).matches()) return null;
                message = args.length > 1 ? args[1].toString() : "";
                logMethod = log4JPriorityAsStr;
            } else {
                message = (args[0] + "").trim();
                logMethod = interceptedMethod;
            }
            ErrorThrowable loggedTh = this.createLoggedThrowable(args);
            ErrorRecord logRecord = this.createLogRecord(logMethod, logTime, message, loggedTh);
            SequenceSpace.SEQUENCE_BOOK.get().getLogRecordBag().add(logRecord);
            return null;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("[Log4jInterceptorDefinition] ");
            sb.append(interceptedClz);
            sb.append('.');
            sb.append(interceptedMethod);
            sb.append(" unable to record the logging");
            JavaAgent.logger.log(Level.WARN, sb.toString(), e);
        }
        return null;
    }
}

