/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.messaging;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ClassMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.messaging.MessagingTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.reflect.Field;

public class ActiveMQInterceptorDefinition
extends TracingInterceptorDefinition {
    public ActiveMQInterceptorDefinition() {
        super(ActiveMQInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new ClassMatcher("org/apache/activemq/ActiveMQMessageProducer"), new ClassMatcher("org/apache/activemq/ActiveMQMessageConsumer")), null, new ManyMethodMatcher(new MethodMatcher("send", new String[]{"(Ljavax/jms/Destination;Ljavax/jms/Message;IIJ)V", "(Ljavax/jms/Destination;Ljavax/jms/Message;IIJLorg/apache/activemq/AsyncCallback;)V"}), new MethodMatcher("receive", new String[]{"()Ljavax/jms/Message;", "(J)Ljavax/jms/Message;"}), new MethodMatcher("receiveNoWait", new String[]{"()Ljavax/jms/Message;"})));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object clientObj, Object[] args) {
        String serverInfo = null;
        BasicPointcutProperties pointcutProperties = new BasicPointcutProperties(className, methodName){

            @Override
            public Component getComponent() {
                return Component.ACTIVEMQ;
            }
        };
        return new MessagingTracker(serverInfo, pointcutProperties, clientObj, args);
    }

    private String extractServerInfo(String className, Object clientObj) {
        try {
            Field sessionField = className.equals("org/apache/activemq/ActiveMQMessageProducer") && clientObj.getClass().getSuperclass().getName().equals("org.apache.activemq.ActiveMQMessageProducerSupport") ? clientObj.getClass().getSuperclass().getDeclaredField("session") : clientObj.getClass().getDeclaredField("session");
            sessionField.setAccessible(true);
            Object amqSession = sessionField.get(clientObj);
            Object amqConnection = amqSession.getClass().getMethod("getConnection", new Class[0]).invoke(amqSession, new Object[0]);
            Object amqTransport = amqConnection.getClass().getMethod("getTransport", new Class[0]).invoke(amqConnection, new Object[0]);
            String remoteAddress = (String)amqTransport.getClass().getMethod("getRemoteAddress", new Class[0]).invoke(amqTransport, new Object[0]);
            return remoteAddress.split("://")[1];
        }
        catch (Throwable t) {
            JavaAgent.logger.log(Level.WARN, "[ActiveMQ] Couldn't extract broker URL", t);
            return null;
        }
    }
}

