/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.interceptor.messaging;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.instrumentation.interceptor.BasicPointcutProperties;
import com.manageengine.apminsight.agent.instrumentation.interceptor.TracingInterceptorDefinition;
import com.manageengine.apminsight.agent.instrumentation.matchers.AnyClassTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.InterfaceTypeMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.ManyMethodMatcher;
import com.manageengine.apminsight.agent.instrumentation.matchers.MethodMatcher;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.messaging.MessagingTracker;
import com.manageengine.org.apache.logging.log4j.Level;

public class RabbitMQInterceptorDefinition
extends TracingInterceptorDefinition {
    public RabbitMQInterceptorDefinition() {
        super(RabbitMQInterceptorDefinition.class.getName(), new AnyClassTypeMatcher(new InterfaceTypeMatcher("com/rabbitmq/client/Channel")), null, new ManyMethodMatcher(new MethodMatcher("basicPublish", new String[]{"(Ljava/lang/String;Ljava/lang/String;ZZLcom/rabbitmq/client/AMQP$BasicProperties;[B)V", "(ILjava/lang/String;Ljava/lang/String;ZZLcom/rabbitmq/client/AMQP$BasicProperties;[B)V"}), new MethodMatcher("basicGet", new String[]{"(Ljava/lang/String;Z)Lcom/rabbitmq/client/GetResponse;", "(ILjava/lang/String;Z)Lcom/rabbitmq/client/GetResponse;"})));
    }

    @Override
    public Tracker getTracker(String className, String methodName, Object clientObj, Object[] args) {
        String serverInfo = null;
        if (JavaAgentConfig.captureHostDetails) {
            serverInfo = this.extractServerInfo(clientObj);
        }
        BasicPointcutProperties pointcutProperties = new BasicPointcutProperties(className, methodName){

            @Override
            public Component getComponent() {
                return Component.RABBITMQ;
            }
        };
        return new MessagingTracker(serverInfo, pointcutProperties, clientObj, args);
    }

    private String extractServerInfo(Object clientObj) {
        try {
            String hostAddress;
            Object connection = clientObj.getClass().getMethod("getConnection", new Class[0]).invoke(clientObj, new Object[0]);
            try {
                Object inetAddress = connection.getClass().getMethod("getAddress", new Class[0]).invoke(connection, new Object[0]);
                hostAddress = (String)inetAddress.getClass().getMethod("getHostAddress", new Class[0]).invoke(inetAddress, new Object[0]);
            }
            catch (NoSuchMethodException e) {
                hostAddress = (String)connection.getClass().getMethod("getHost", new Class[0]).invoke(connection, new Object[0]);
            }
            String hostPort = String.valueOf(connection.getClass().getMethod("getPort", new Class[0]).invoke(connection, new Object[0]));
            return hostAddress + ":" + hostPort;
        }
        catch (Throwable t) {
            JavaAgent.logger.log(Level.WARN, "[RabbitMQ] Couldn't extract broker address", t);
            return null;
        }
    }
}

