/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.instrumentation.matchers;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.matchers.TypeMatcher;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.Arrays;
import java.util.regex.Pattern;

public class MethodMatcher
implements TypeMatcher {
    public static final String MATCH_ALL = "/.*/";
    protected String methodName;
    protected String[] methodDescription;
    private static final String IS_REGEX = "/.*/";

    public MethodMatcher() {
    }

    public MethodMatcher(String methodName, String methodDescription) {
        this(methodName, new String[]{methodDescription});
    }

    public MethodMatcher(String methodName, String[] methodDescription) {
        this.methodName = this.isRegex(methodName) ? this.extractPattern(methodName) : Pattern.quote(methodName);
        this.methodDescription = new String[methodDescription.length];
        for (int i = 0; i < methodDescription.length; ++i) {
            String description = methodDescription[i];
            this.methodDescription[i] = this.isRegex(description) ? this.extractPattern(description) : Pattern.quote(description);
        }
    }

    public boolean isRegex(String s) {
        return s.matches("/.*/");
    }

    public String extractPattern(String regex) {
        return regex.substring(1, regex.length() - 1);
    }

    public boolean matches(String name, String description) {
        JavaAgent.logger.log(Level.TRACE, "MethodMatcher Matching {}{} with {}{} ", name, description, this.methodName, Arrays.asList(this.methodDescription));
        boolean methodNameMatches = name.matches(this.methodName);
        if (!methodNameMatches) {
            return false;
        }
        JavaAgent.logger.trace("Method name matches");
        for (String desc : this.methodDescription) {
            if (desc == null || !description.matches(desc)) continue;
            JavaAgent.logger.trace("Method description matches");
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String thisClassName = this.getClass().getName();
        sb.append(thisClassName.substring(thisClassName.lastIndexOf(46) + 1));
        sb.append("[").append(this.methodName).append(" ").append(Arrays.asList(this.methodDescription)).append("]");
        return sb.toString();
    }
}

