/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.jmx;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.jmx.AbstractJmxExtension;
import com.manageengine.apminsight.agent.jmx.JmxBean;
import com.manageengine.apminsight.agent.util.FileUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.File;

public class CustomJmxExtension
extends AbstractJmxExtension {
    private static CustomJmxExtension extension;

    private CustomJmxExtension() {
        this.initialize(new File(JavaAgent.getInstance().agentConfig.getAgentInstallDir(), "jmx_extensions.conf"));
    }

    public static CustomJmxExtension getInstance() {
        if (extension == null) {
            extension = new CustomJmxExtension();
        }
        return extension;
    }

    public void initialize(File confFile) {
        if (!confFile.exists()) {
            return;
        }
        try {
            String content = FileUtil.getInstance().readCharacterFile(confFile);
            String[] jmxBeans = content.split("\\n");
            this.initialize(jmxBeans);
        }
        catch (Exception e) {
            JavaAgent.logger.log(Level.WARN, "Unable to initialize custom JMX extension.", e);
        }
    }

    public void initialize(String[] jmxBeans) {
        this.getJmxBeans().clear();
        for (String jmxBean : jmxBeans) {
            String[] sections = jmxBean.split("(?<!\\\\)\\s", 3);
            if (sections.length > 1) {
                this.addJmxBean(new JmxBean(sections[0].replaceAll("\\\\\\s", " "), sections.length == 2 ? "" : StringUtils.removeAllWhiteSpaces(sections[1]), StringUtils.removeAllWhiteSpaces(sections[sections.length == 2 ? 1 : 2]).split(",")));
                continue;
            }
            JavaAgent.logger.warn("[CustomJMX] Unable to create custom jmxbean improper format: " + jmxBean);
        }
        JavaAgent.logger.info("[CustomJMX] Custom JMX extenstion initalization successfull");
    }

    @Override
    public String getJMXPrefix() {
        return "JMX-Custom-";
    }
}

