/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.jvm;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.communication.http.HttpClientBuilder;
import com.manageengine.apminsight.agent.communication.http.HttpConfig;
import com.manageengine.org.apache.hc.client5.http.classic.methods.HttpGet;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.manageengine.org.apache.hc.core5.http.io.entity.EntityUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostEnvIdentifier
implements JavaAgentConstants {
    public static String getHostType() {
        CloseableHttpResponse response;
        HttpGet request2;
        CloseableHttpClient httpClient;
        File dockerFile = new File("/proc/self/cgroup");
        if (dockerFile.exists() && dockerFile.canRead() && HostEnvIdentifier.isDocker(dockerFile)) {
            JavaAgent.logger.info("Agent is hosted in DOCKER");
            return "DOCKER";
        }
        if (System.getenv("WEBSITE_SITE_NAME") != null && System.getenv("KUDU_APPPATH") != null) {
            JavaAgent.logger.info("Agent is hosted in AZURE WEBAPP service");
            return "AZURE_WEBAPP";
        }
        try {
            httpClient = new HttpClientBuilder().setHttpConfig(new HttpConfig(2, 1)).build();
        }
        catch (Exception e) {
            JavaAgent.logger.error("[HostEnvIdentifier] Error initializing HttpClient", e);
            return HostEnvIdentifier.getFallbackHostType();
        }
        try {
            request2 = new HttpGet("http://169.254.169.254/latest/meta-data/instance-id");
            response = httpClient.execute(request2);
            if (response.getCode() == 200) {
                JavaAgent.logger.info("Agent is hosted in AWS EC2");
                String ec2InstanceID = EntityUtils.toString(response.getEntity());
                System.setProperty("cloud.instance.id", ec2InstanceID);
                return "AWS";
            }
        }
        catch (Throwable request2) {
            // empty catch block
        }
        try {
            String uri = System.getenv("ECS_CONTAINER_METADATA_URI");
            uri = uri == null ? "http://169.254.170.2/v2/metadata" : uri;
            HttpGet request3 = new HttpGet(uri);
            CloseableHttpResponse response2 = httpClient.execute(request3);
            if (response2.getCode() == 200) {
                JavaAgent.logger.info("Agent is hosted in AWS Fargate");
                return "AWS";
            }
        }
        catch (Throwable uri) {
            // empty catch block
        }
        try {
            request2 = new HttpGet("http://169.254.169.254/metadata/v1/maintenance");
            response = httpClient.execute(request2);
            if (response.getCode() == 200) {
                JavaAgent.logger.info("Agent is hosted in AZURE VM");
                return "AZURE_VM";
            }
        }
        catch (Throwable request4) {
            // empty catch block
        }
        try {
            request2 = new HttpGet("http://metadata.google.internal/computeMetadata/v1/instance/id");
            request2.addHeader("Metadata-Flavor", "Google");
            response = httpClient.execute(request2);
            if (response.getCode() == 200) {
                JavaAgent.logger.info("Agent is hosted in GCP");
                return "GCP";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            httpClient.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return HostEnvIdentifier.getFallbackHostType();
    }

    private static String getFallbackHostType() {
        String hostType = System.getProperty("agent.host.environment");
        if (hostType != null) {
            JavaAgent.logger.info("Agent is hosted in custom environment: " + hostType);
            return hostType.toUpperCase();
        }
        return "";
    }

    private static boolean isDocker(File dockerFile) {
        try {
            String line;
            Pattern p = Pattern.compile("^/(docker/|lxc/|.+?/docker-|ecs/.+?/)([a-f0-9]+)($|\\.scope)");
            BufferedReader reader = new BufferedReader(new FileReader(dockerFile));
            String dockId = null;
            while ((line = reader.readLine()) != null) {
                Matcher m;
                String[] parts = line.split(":");
                if (parts.length != 3 || !parts[1].matches("^cpu(.+|$)") || !(m = p.matcher(parts[2])).matches()) continue;
                dockId = m.group(2);
                break;
            }
            if (dockId != null && System.getProperty("apminsight.hostname") == null) {
                System.setProperty("apminsight.hostname", dockId);
            }
            reader.close();
            return dockId != null;
        }
        catch (IOException ioe) {
            return false;
        }
    }
}

