/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.jvm.monitor;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.metric.MetricConstants;
import com.manageengine.apminsight.agent.metrics.VirtualMachineMetric;
import com.manageengine.apminsight.agent.util.JavaAgentUtil;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.HashMap;

public class VmMetricsCollector
implements MetricConstants {
    private long vmUpTime = -1L;
    private long jitCompilationTime = -1L;
    private long prevJitCompilationTime = -1L;
    private int availProcessors = -1;
    private long totalMemory = -1L;
    private long freeMemory = -1L;
    private long loadedClassCount = -1L;
    private long unloadedClassCount = -1L;
    private long totalLoadedClassCount = -1L;
    private HashMap<String, Long[]> memoryUsage = new HashMap();
    private HashMap<String, Long[]> garbageCollector = new HashMap();

    public VirtualMachineMetric startDataCollection() {
        this.reset();
        this.collectMetrics();
        return this.formatCollectedData();
    }

    private void collectMetrics() {
        try {
            this.collectRuntimeBeanMetrics();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[VmMetricsCollector] Failed to get metrics from RuntimeMXBean / Runtime instance", th);
        }
        try {
            this.collectCompilationBeanMetrics();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[VmMetricsCollector] Failed to get metrics from CompilationMXBean instance.", th);
        }
        try {
            this.collectClassLoadingBeanMetrics();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[VmMetricsCollector] Failed to get metrics from ClassLoadingMXBean instance.", th);
        }
        try {
            this.collectGarbageCollectorBeanMetrics();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[VmMetricsCollector] Failed to get metrics from GarbageCollectorMXBeans instance.", th);
        }
        try {
            this.collectMemoryPoolBeanMetrics();
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "[VmMetricsCollector] Failed to get metrics from MemoryPoolMXBeans instance.", th);
        }
    }

    private void collectRuntimeBeanMetrics() throws Throwable {
        this.vmUpTime = ManagementFactory.getRuntimeMXBean().getUptime();
        Runtime r = Runtime.getRuntime();
        this.availProcessors = r.availableProcessors();
        this.totalMemory = JavaAgentUtil.convertBytesToMB(r.totalMemory());
        this.freeMemory = JavaAgentUtil.convertBytesToMB(r.freeMemory());
    }

    private void collectCompilationBeanMetrics() throws Throwable {
        CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
        if (compilationMXBean.isCompilationTimeMonitoringSupported()) {
            this.jitCompilationTime = compilationMXBean.getTotalCompilationTime() - this.prevJitCompilationTime;
            this.prevJitCompilationTime += this.jitCompilationTime;
        } else {
            this.prevJitCompilationTime = -1L;
            this.jitCompilationTime = -1L;
        }
    }

    private void collectGarbageCollectorBeanMetrics() throws Throwable {
        for (GarbageCollectorMXBean gcMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            String gcName = gcMXBean.getName();
            Long[] gcData = this.garbageCollector.get(gcName);
            if (gcData == null) {
                gcData = new Long[]{0L, 0L, 0L, 0L};
            }
            gcData[0] = gcMXBean.getCollectionCount() - gcData[2];
            gcData[1] = gcMXBean.getCollectionTime() - gcData[3];
            Long[] longArray = gcData;
            Long.valueOf(longArray[2] + gcData[0]);
            longArray = gcData;
            Long.valueOf(longArray[3] + gcData[1]);
            this.garbageCollector.put(gcName, gcData);
        }
    }

    private void collectClassLoadingBeanMetrics() throws Throwable {
        ClassLoadingMXBean clsMXBean = ManagementFactory.getClassLoadingMXBean();
        this.loadedClassCount = clsMXBean.getLoadedClassCount();
        this.unloadedClassCount = clsMXBean.getUnloadedClassCount();
        this.totalLoadedClassCount = clsMXBean.getTotalLoadedClassCount();
    }

    private void collectMemoryPoolBeanMetrics() throws Throwable {
        MemoryUsage memUsage = null;
        Long[] memory = null;
        for (MemoryPoolMXBean memoryMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            memUsage = memoryMXBean.getUsage();
            memory = new Long[]{JavaAgentUtil.convertBytesToMB(memUsage.getUsed()), JavaAgentUtil.convertBytesToMB(memUsage.getCommitted()), JavaAgentUtil.convertBytesToMB(memUsage.getMax())};
            this.memoryUsage.put(this.standardizePoolName(memoryMXBean.getName()), memory);
        }
    }

    private String standardizePoolName(String name) {
        if (name.contains("Perm Gen [shared-ro]")) {
            return "Perm Gen [shared-ro]";
        }
        if (name.contains("Perm Gen [shared-rw]")) {
            return "Perm Gen [shared-rw]";
        }
        if (name.contains("Perm Gen") || name.equals("class storage")) {
            return "Perm Gen";
        }
        if (name.contains("Old Gen") || name.contains("Tenured Gen")) {
            return "Tenured Gen";
        }
        if (name.contains("Code Cache") || name.equals("JIT code cache")) {
            return "Code Cache";
        }
        if (name.contains("Eden Space") || name.equals("Java heap")) {
            return "Eden Space";
        }
        if (name.contains("Survivor Space")) {
            return "Survivor Space";
        }
        return name;
    }

    private VirtualMachineMetric formatCollectedData() {
        VirtualMachineMetric vmMetric = new VirtualMachineMetric();
        vmMetric.recordData(this.vmUpTime, this.availProcessors, this.jitCompilationTime, this.totalMemory, this.freeMemory, this.loadedClassCount, this.unloadedClassCount, this.totalLoadedClassCount, this.memoryUsage, this.garbageCollector);
        return vmMetric;
    }

    private void reset() {
        this.vmUpTime = -1L;
        this.jitCompilationTime = -1L;
        this.availProcessors = -1;
        this.totalMemory = -1L;
        this.freeMemory = -1L;
        this.loadedClassCount = -1L;
        this.unloadedClassCount = -1L;
        this.totalLoadedClassCount = -1L;
        this.memoryUsage.clear();
    }
}

