/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.actions;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.memory.calc.MemoryCalculator;
import com.manageengine.apminsight.agent.memoryleaks.actions.ObjectActions;
import com.manageengine.apminsight.agent.memoryleaks.config.ActionHandler;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryLeaksEvents;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectDetails;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectSummaryHandler
implements ObjectActions {
    private volatile boolean enabled = Boolean.TRUE;
    public Map<Long, ActionHandler> dumpMap = new ConcurrentHashMap<Long, ActionHandler>();
    public Map<Long, ActionHandler> summaryMap = new ConcurrentHashMap<Long, ActionHandler>();
    public ObjectMonitor objectMonitor;

    public ObjectSummaryHandler(ObjectMonitor objectMonitor) {
        this.objectMonitor = objectMonitor;
    }

    public void disable() {
        this.enabled = false;
        this.dumpMap.clear();
        this.summaryMap.clear();
    }

    public void enable() {
        this.enabled = true;
    }

    @Override
    public void addUserAction(List<ActionHandler> actionHandler) {
        for (ActionHandler handler : actionHandler) {
            this.addUserAction(handler);
        }
    }

    @Override
    public void addUserAction(ActionHandler actionHandler) {
        if (!this.enabled) {
            return;
        }
        ObjectDetails details = this.objectMonitor.getObjectDetailsForId(actionHandler.getObjectUUID());
        if (actionHandler.getAgentActionId() == 2) {
            if (this.summaryMap.size() < 6) {
                if (!this.summaryMap.containsKey(actionHandler.getObjectUUID())) {
                    if (details != null && details.getObject() != null) {
                        actionHandler.setClassName(details.getPackageStructureClazzName());
                        ArrayList<String> params = new ArrayList<String>();
                        params.add(details.getPackageStructureClazzName());
                        this.summaryMap.put(actionHandler.getObjectUUID(), actionHandler);
                        MemoryLeaksEvents.getInstance().addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.summary.start", params);
                    } else {
                        MemoryLeaksEvents.getInstance().addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.not.available");
                        JavaAgent.logger.info("Object with objId:" + actionHandler.getObjectUUID() + " is not Available.");
                    }
                }
            } else {
                ArrayList<Object> params = new ArrayList<Object>();
                params.add(ContextInfoManager.getInstance().getDefaultContextInfo().getInstanceID());
                params.add(actionHandler.getObjectUUID());
                MemoryLeaksEvents.getInstance().addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.summary.max", params);
                JavaAgent.logger.warn("processing threashold exceeded, Object summary couldn't be process");
            }
        }
    }

    public boolean enableObjectContent(MemoryCalculator memoryCalc, long currSize, long objectUUID) {
        long prevSize;
        ActionHandler handler = this.summaryMap.get(objectUUID);
        if (handler != null && ((prevSize = handler.getPrevSize()) == -1L || currSize != prevSize)) {
            memoryCalc.setIsSummaryEnabled(Boolean.TRUE);
            handler.setPrevSize(currSize);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean enableObjectDump(MemoryCalculator memoryCalc, long objectUUID) {
        ActionHandler handler = this.dumpMap.get(objectUUID);
        if (handler != null) {
            memoryCalc.setIsDumpEnabled(Boolean.TRUE);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void disableObjectContent(MemoryCalculator memoryCalc, long objectUUID) {
        memoryCalc.setIsDumpEnabled(Boolean.FALSE);
        memoryCalc.setIsSummaryEnabled(Boolean.FALSE);
        if (this.dumpMap.containsKey(objectUUID)) {
            this.dumpMap.remove(objectUUID);
        }
        if (this.summaryMap.containsKey(objectUUID)) {
            this.summaryMap.remove(objectUUID);
        }
    }

    public void closeObjectSummary(MemoryCalculator memoryCalc, long objectUUID) {
        Long timeNow;
        memoryCalc.setIsSummaryEnabled(Boolean.FALSE);
        ActionHandler actionHandler = this.summaryMap.get(objectUUID);
        if (actionHandler != null && (timeNow = Long.valueOf(System.currentTimeMillis())) - actionHandler.getInitTime() > actionHandler.getCaptureDurationInMillis()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(actionHandler.getClassName());
            MemoryLeaksEvents.getInstance().addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.summary.stop", params);
            this.summaryMap.remove(objectUUID);
        }
    }

    public void closeObjectDump(MemoryCalculator memoryCalc, long objectUUID) {
        memoryCalc.setIsDumpEnabled(Boolean.FALSE);
        ActionHandler actionHandler = this.dumpMap.get(objectUUID);
        if (actionHandler != null) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(actionHandler.getClassName());
            MemoryLeaksEvents.getInstance().addUiEvent(actionHandler.getObjectUUID(), "apminsight.memoryleaks.dump.stop", params);
            this.dumpMap.remove(objectUUID);
        }
    }
}

