/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.actions;

import com.manageengine.apminsight.agent.memoryleaks.actions.ObjectActions;
import com.manageengine.apminsight.agent.memoryleaks.actions.TraceObjectData;
import com.manageengine.apminsight.agent.memoryleaks.config.ActionHandler;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectDetails;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ObjectTraceHandler
implements ObjectActions {
    public static final int MAX_TRACE_PATHS = 16;
    public static volatile int max_stack_trace_depth = 12;
    public static final int MAX_STACK_TRACES_PER_MIN = 60;
    public static final int MAX_ACTIVE_TRACES = 6;
    private TraceObjectData objectTracer = null;
    public static volatile AtomicInteger runningTraceCount = new AtomicInteger(0);

    @Override
    public void addUserAction(List<ActionHandler> handlerList) {
        HashSet<ActionHandler> traceTargets = new HashSet<ActionHandler>();
        ObjectMonitor monitor = ObjectMonitor.getInstance();
        for (int i = 0; i < handlerList.size(); ++i) {
            ActionHandler handlerObj = handlerList.get(i);
            if (!monitor.isObjectIdExists(handlerObj.getObjectUUID())) continue;
            ObjectDetails details = monitor.getObjectDetailsForId(handlerObj.getObjectUUID());
            String className = details.getPackageStructureClazzName();
            handlerObj.setClassName(className);
            traceTargets.add(handlerObj);
        }
        if (!traceTargets.isEmpty()) {
            this.initializeTracer();
            this.objectTracer.registerTraceSession(traceTargets);
        }
    }

    public void addToTracer(Object obj) {
        long id;
        if (obj != null && (id = ObjectMonitor.getInstance().getUniqueIdFromObject(obj)) != -1L) {
            this.objectTracer.captureTransactionalTrace(id);
        }
    }

    private void initializeTracer() {
        if (this.objectTracer == null || !this.objectTracer.isEnabled()) {
            this.objectTracer = TraceObjectData.getInstance();
            this.objectTracer.init();
        }
    }

    @Override
    public void addUserAction(ActionHandler actionHandler) {
        ArrayList<ActionHandler> handlerList = new ArrayList<ActionHandler>();
        handlerList.add(actionHandler);
        this.addUserAction(handlerList);
    }

    public void disableTraceObjectData() {
        if (this.objectTracer != null) {
            this.objectTracer.finish();
        }
    }

    public TraceObjectData getTraceObjectData() {
        if (this.objectTracer != null) {
            return this.objectTracer;
        }
        return null;
    }
}

