/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.config;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memoryleaks.actions.ObjectActions;
import com.manageengine.apminsight.agent.memoryleaks.actions.ObjectSummaryHandler;
import com.manageengine.apminsight.agent.memoryleaks.actions.ObjectTraceHandler;
import com.manageengine.apminsight.agent.memoryleaks.config.ActionHandler;
import com.manageengine.apminsight.agent.memoryleaks.config.LeakDetectionConfig;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryAnalyzer;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryLeaksEvents;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectMonitor;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.LeakObservation;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.SchedulerManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AutomaticLeakDetection {
    private static volatile Boolean isActive = false;
    private ObjectMonitor objectMonitor = null;
    private ObjectSummaryHandler objectSummary = null;
    private ObjectTraceHandler traceHandler = null;
    private MemoryAnalyzer memoryAnalyzer = null;
    private MemoryLeaksEvents eventSender = null;
    private ScheduledFuture<?> memoryScheduler;
    private static AutomaticLeakDetection instance;

    private AutomaticLeakDetection() {
    }

    private void initialize() {
        this.objectMonitor = ObjectMonitor.getInstance();
        this.eventSender = MemoryLeaksEvents.getInstance();
        this.eventSender.initialize();
        this.objectSummary = new ObjectSummaryHandler(this.objectMonitor);
        this.traceHandler = new ObjectTraceHandler();
        this.memoryAnalyzer = new MemoryAnalyzer(this.objectMonitor, this.objectSummary);
        this.scheduleMemoryAnalyzer();
    }

    private void scheduleMemoryAnalyzer() {
        if (this.memoryScheduler != null) {
            this.memoryScheduler.cancel(false);
        }
        this.memoryScheduler = SchedulerManager.getGlobalScheduler().scheduleAtFixedRate(this.memoryAnalyzer, 60L, 90L, TimeUnit.SECONDS);
    }

    public static AutomaticLeakDetection getInstance() {
        if (instance == null) {
            instance = new AutomaticLeakDetection();
        }
        return instance;
    }

    public MemoryAnalyzer getMemoryAnalyzer() {
        if (!isActive.booleanValue()) {
            return null;
        }
        return this.memoryAnalyzer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        Boolean bl = isActive;
        synchronized (bl) {
            if (isActive.booleanValue()) {
                JavaAgent.logger.warn("---Automatic Leak Detection is alerady running---");
                this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.running");
                return;
            }
            this.clear();
            this.initialize();
            this.objectMonitor.enableObjectMonitor();
            this.objectSummary.enable();
            this.scheduleMemoryAnalyzer();
            isActive = Boolean.TRUE;
        }
        JavaAgent.logger.info("---Automatic Leak Detection is Activated now---");
        this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.analysis.start");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deActivate() {
        Boolean bl = isActive;
        synchronized (bl) {
            this.clear();
            isActive = Boolean.FALSE;
        }
        JavaAgent.logger.info("---Automatic Leak Detection is DeActivated now---");
        this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.analysis.stop");
    }

    private void clear() {
        OnDemandCollectionRecorder.getInstance().deActivate();
        if (this.objectMonitor != null) {
            this.objectMonitor.clearObjectMonitorData();
        }
        if (this.objectSummary != null) {
            this.objectSummary.disable();
        }
        if (this.traceHandler != null) {
            this.traceHandler.disableTraceObjectData();
        }
        this.traceHandler = null;
        this.objectSummary = null;
        if (this.memoryScheduler != null) {
            this.memoryScheduler.cancel(true);
            this.memoryScheduler = null;
        }
        if (this.eventSender != null) {
            this.eventSender.clear();
        }
    }

    public static boolean isActive() {
        return isActive;
    }

    public ObjectSummaryHandler getObjectSummary() {
        if (!isActive.booleanValue()) {
            return null;
        }
        return this.objectSummary;
    }

    public ObjectTraceHandler getObjectTraceHandler() {
        if (!isActive.booleanValue()) {
            return null;
        }
        return this.traceHandler;
    }

    public void delegateAction(Map<Integer, List<ActionHandler>> actionMap) {
        if (actionMap == null || actionMap.isEmpty()) {
            return;
        }
        for (int actionId : ActionHandler.USER_ACTION_ARR) {
            ObjectActions objectAction;
            List<ActionHandler> handlerList = null;
            handlerList = actionMap.get(actionId);
            if (handlerList == null || (objectAction = this.getObjectAction(actionId)) == null) continue;
            objectAction.addUserAction(handlerList);
        }
    }

    private ObjectActions getObjectAction(int actionId) {
        if (actionId == 1 || actionId == 2) {
            return this.objectSummary;
        }
        if (actionId == 3) {
            return this.traceHandler;
        }
        return null;
    }

    public void addToTracer(Object obj) {
        if (!isActive.booleanValue() || ObjectTraceHandler.runningTraceCount.get() < 1) {
            return;
        }
        this.traceHandler.addToTracer(obj);
    }

    public static class OnDemandCollectionRecorder {
        private volatile LeakObservation leakObservation = null;
        private volatile int captureTimeInMins;
        private volatile int objectDurationInMins;
        private static OnDemandCollectionRecorder onDemandCollectionRecorderInstance;

        private OnDemandCollectionRecorder() {
            LeakDetectionConfig.setMemoryCalculator(JavaAgent.getInstance().getInstrumentation());
        }

        public static OnDemandCollectionRecorder getInstance() {
            if (onDemandCollectionRecorderInstance == null) {
                onDemandCollectionRecorderInstance = new OnDemandCollectionRecorder();
            }
            return onDemandCollectionRecorderInstance;
        }

        public void deActivate() {
            JavaAgent.logger.info("Deactivated the Collection recorder (ActivateCollectionRecorder class) obj : " + this.leakObservation);
            if (this.leakObservation != null) {
                this.leakObservation.finishObservation();
                this.leakObservation = null;
            }
        }

        public void clear() {
            this.leakObservation = null;
        }

        public void addToRouter(Object collectionObj) {
            if (this.leakObservation != null) {
                this.leakObservation.addToRouter(collectionObj);
            }
        }

        public synchronized void startOnDemandCollectionRecorder(int captureTimeInMins, int objectDurationInMins) {
            AutomaticLeakDetection automaticLd = AutomaticLeakDetection.getInstance();
            if (isActive.booleanValue() && this.leakObservation == null) {
                this.captureTimeInMins = captureTimeInMins;
                this.objectDurationInMins = objectDurationInMins;
                this.leakObservation = new LeakObservation(this);
                this.leakObservation.init();
            } else {
                JavaAgent.logger.info("On Demand Collection Recorder is currently active. Please try after some time, AutomaticLeak detection is " + isActive);
            }
        }

        public int getCaptureTimeInMins() {
            return this.captureTimeInMins;
        }

        public int getObjectDurationInMins() {
            return this.objectDurationInMins;
        }
    }
}

