/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.monitor;

import com.manageengine.apminsight.agent.memoryleaks.monitor.Histogram;
import java.lang.ref.WeakReference;
import java.util.Map;

public class ObjectDetails {
    private int hashId;
    private long objectUUID;
    private String hashKey;
    private String name;
    private long time;
    private String clazzName;
    private String objectType;
    private long objectCapturedTime;
    private Map<String, String> detailsMap;
    private WeakReference<Object> obj;
    private long elementsSize = -1L;
    private Histogram histogram;

    public static String getName(Class aClazz) {
        return aClazz.getName();
    }

    private ObjectDetails(int hashId, String objectName, long age, Object obj, long objectCapturedTime) {
        this.hashId = hashId;
        this.hashKey = String.valueOf(hashId);
        this.name = objectName;
        this.time = age;
        this.objectCapturedTime = objectCapturedTime;
        this.obj = new WeakReference<Object>(obj);
        this.clazzName = ObjectDetails.getName(obj.getClass());
    }

    public ObjectDetails(int hashId, String objectName, long age, Object obj, long objectCapturedTime, long elementsSize, Histogram histogram, String objectType) {
        this(hashId, objectName, age, obj, objectCapturedTime);
        this.elementsSize = elementsSize;
        this.histogram = histogram;
        this.objectType = objectType == null ? "others" : objectType;
    }

    public Object getObject() {
        return this.obj.get();
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public String getName() {
        return this.name;
    }

    public long getDescription() {
        return this.time;
    }

    public int getHashId() {
        return this.hashId;
    }

    public long getSize() {
        return this.elementsSize;
    }

    public long getObjectCapturedTime() {
        return this.objectCapturedTime;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public boolean isCollectionObject() {
        return "collection".equals(this.objectType);
    }

    public boolean isMapObject() {
        return "map".equals(this.objectType);
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public String getPackageStructureClazzName() {
        return this.clazzName.replaceAll("\\.", "/");
    }

    public long getObjectUUID() {
        return this.objectUUID;
    }

    public void setObjectUUID(long objectUUID) {
        this.objectUUID = objectUUID;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectDetails");
        Object obj = this.getObject();
        if (obj != null) {
            sb.append(" object-class=").append(ObjectDetails.getName(obj.getClass()));
        } else {
            sb.append("-- GC details");
        }
        sb.append(", Clazz Name='").append(this.name).append("-");
        sb.append(", HashKey='").append(this.hashKey).append(" - ");
        sb.append(", Age='").append(this.time).append("-");
        sb.append(", Object Type='").append(this.objectType).append("-");
        sb.append(", detaisMap=").append(this.detailsMap);
        sb.append("--");
        return sb.toString();
    }
}

