/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.monitor;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memory.calc.CalculatorUtil;
import com.manageengine.apminsight.agent.memory.calc.MemoryCalculator;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectDetails;
import com.manageengine.apminsight.agent.memoryleaks.monitor.RegressionModel;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectMonitor {
    private volatile int totalObjectCounter = 0;
    private final MemoryCalculator calculator;
    private int maxObjects = 25;
    private static int randomMin = 10000;
    private static int randomMax = 100000;
    private Random random = new Random(System.currentTimeMillis());
    private final Map<Object, Long> objectDetailsToSize = new WeakHashMap<Object, Long>();
    private final Map<Long, ObjectDetails> trackedIdToObjectType = new ConcurrentHashMap<Long, ObjectDetails>(512);
    private final Map<Long, Boolean> leakObject = new LinkedHashMap<Long, Boolean>(64);
    private final Map<Long, RegressionModel> regressionMap = new ConcurrentHashMap<Long, RegressionModel>(512);
    private volatile boolean isEnabled = true;
    private static ObjectMonitor objectMonitor = new ObjectMonitor(JavaAgent.getInstance().getInstrumentation());

    public ObjectMonitor(Instrumentation instrumentation) {
        this.calculator = new MemoryCalculator(instrumentation);
        Collections.synchronizedMap(this.objectDetailsToSize);
        JavaAgent.logger.info(" Object monitor started with Instrumentation object : " + instrumentation);
    }

    public static ObjectMonitor getInstance() {
        return objectMonitor;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void clearObjectMonitorData() {
        this.isEnabled = false;
        this.trackedIdToObjectType.clear();
        this.objectDetailsToSize.clear();
        this.leakObject.clear();
        this.regressionMap.clear();
    }

    public void enableObjectMonitor() {
        this.isEnabled = true;
    }

    public boolean monitorObjectSize(ObjectDetails objectDetails) {
        if (this.isObjectLimitExceeded()) {
            return false;
        }
        return this.trackObject(objectDetails);
    }

    public boolean isObjectLimitExceeded() {
        if (this.objectDetailsToSize.size() >= this.maxObjects) {
            if (CalculatorUtil.isDebugEnabled.booleanValue()) {
                JavaAgent.logger.info("The limit of Object  " + this.objectDetailsToSize.size() + " exceeded the max limit " + this.maxObjects);
            }
            ++this.totalObjectCounter;
            if (this.totalObjectCounter % 100 == 0) {
                JavaAgent.logger.info("The limit of Object  " + this.objectDetailsToSize.size() + " exceeded, no new objects will be tracked " + this.totalObjectCounter);
                this.totalObjectCounter = 0;
            }
            return true;
        }
        return false;
    }

    private int getRandomInt(int min, int max) {
        return this.random.nextInt(max - min + 1) + min;
    }

    private long getUUID(int hashCode) {
        int signum = 1;
        if (hashCode != 0) {
            signum = Integer.signum(hashCode);
        }
        return (long)hashCode * (long)randomMax * 1000L + (long)(this.getRandomInt(randomMin, randomMax) * signum);
    }

    private boolean trackObject(ObjectDetails objectDetails) {
        try {
            if (objectDetails.getObject() == null || this.containsKey(this.objectDetailsToSize, objectDetails.getObject())) {
                return false;
            }
            long objectUUID = this.getUUID(objectDetails.getHashId());
            this.objectDetailsToSize.put(objectDetails.getObject(), objectUUID);
            objectDetails.setObjectUUID(objectUUID);
            this.trackedIdToObjectType.put(objectUUID, objectDetails);
            if (objectDetails.getHistogram() != null) {
                objectDetails.getHistogram().setObjectUUID(objectUUID);
            }
            RegressionModel model = new RegressionModel(objectDetails.getName(), 20);
            model.addData(System.currentTimeMillis(), objectDetails.getSize());
            this.regressionMap.put(objectUUID, model);
        }
        catch (Exception e) {
            JavaAgent.logger.fatal("Exception in trackObject", e);
            return false;
        }
        return true;
    }

    private boolean containsKey(Map<Object, Long> currentObject, Object newObject) {
        for (Object obj : currentObject.keySet()) {
            if (obj != newObject) continue;
            return true;
        }
        return false;
    }

    public ObjectDetails getObjectDetailsForId(long hashId) {
        return this.trackedIdToObjectType.get(hashId);
    }

    public boolean isObjectIdExists(long uuid) {
        return this.trackedIdToObjectType.get(uuid) != null && this.trackedIdToObjectType.get(uuid).getObject() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isObjectAlreadyTracked(Object obj) {
        Map<Object, Long> map = this.objectDetailsToSize;
        synchronized (map) {
            Set<Object> keys = this.objectDetailsToSize.keySet();
            return keys.contains(obj);
        }
    }

    public Map<Object, Long> getobjectDetailsToSize() {
        return this.objectDetailsToSize;
    }

    public Map<Long, ObjectDetails> getTrackedIdToObjectType() {
        return this.trackedIdToObjectType;
    }

    public void removeObjectUUIDFromTrackedIds(ArrayList<Long> removedIds) {
        for (Long id : removedIds) {
            if (!this.trackedIdToObjectType.containsKey(id)) continue;
            this.trackedIdToObjectType.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUniqueIdFromObject(Object obj) {
        Map<Object, Long> map = this.objectDetailsToSize;
        synchronized (map) {
            for (Map.Entry<Object, Long> entry : this.objectDetailsToSize.entrySet()) {
                if (!obj.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return -1L;
    }

    public MemoryCalculator getMemoryCalculator() {
        return this.calculator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean monitorLeakObject(long uniqueId) {
        Map<Long, Boolean> map = this.leakObject;
        synchronized (map) {
            if (!this.leakObject.containsKey(uniqueId)) {
                this.leakObject.put(uniqueId, Boolean.FALSE);
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLeakObject(long objectUUID) {
        Map<Long, Boolean> map = this.leakObject;
        synchronized (map) {
            if (this.leakObject.containsKey(objectUUID)) {
                this.leakObject.remove(objectUUID);
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    public Map<Long, Boolean> getLeakObject() {
        return this.leakObject;
    }

    public Map<Long, RegressionModel> getRegressionMap() {
        return this.regressionMap;
    }

    public RegressionModel getRegressionModelForId(Long objectUUID) {
        return this.regressionMap.get(objectUUID);
    }
}

