/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.memoryleaks.monitor.collections;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.memory.calc.CalculatorUtil;
import com.manageengine.apminsight.agent.memoryleaks.config.LeakDetectionConfig;
import com.manageengine.apminsight.agent.memoryleaks.config.MemoryLeaksEvents;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectDetails;
import com.manageengine.apminsight.agent.memoryleaks.monitor.ObjectMonitor;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.CollectionObjectRouter;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.LeakObservation;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.MemoryLeaksHolder;
import com.manageengine.apminsight.agent.memoryleaks.monitor.collections.SchedulerManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class LeakObjectAnalysis
implements Runnable {
    private LeakObservation leakObservation;
    private CollectionObjectRouter router;
    private ObjectMonitor objectMon = ObjectMonitor.getInstance();
    private int initialDelay = 60;
    private int index = 0;
    private volatile boolean isActive = true;
    private StatsHolder stats = null;
    private final Map<String, Integer> histogramCountForDeepSized = new HashMap<String, Integer>(512);
    private final Map<String, Integer> histogramCountForShallowSized = new HashMap<String, Integer>(512);
    private ScheduledFuture<?> analyzerFuture;
    private MemoryLeaksEvents eventSender = MemoryLeaksEvents.getInstance();
    private final List<MemoryLeaksHolder> liveObjectSeries;
    private volatile boolean enabled = true;

    public LeakObjectAnalysis(CollectionObjectRouter router, LeakObservation leakObservation) {
        this.router = router;
        this.leakObservation = leakObservation;
        this.stats = new StatsHolder();
        this.initialDelay = leakObservation.getObjectDurationInMins();
        this.liveObjectSeries = new ArrayList<MemoryLeaksHolder>(512);
    }

    public void init() {
        int delay = this.initialDelay * 60 + 20;
        this.analyzerFuture = SchedulerManager.getGlobalScheduler().scheduleWithFixedDelay(this, delay, 60L, TimeUnit.SECONDS);
        JavaAgent.logger.info("Starting LeakObjectAnalysis in --" + this.initialDelay + "-- mins (LeakObjectAnalysis)");
        this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.analysis.start");
    }

    public void setInitialDelay(int initialDelay) {
        this.initialDelay = initialDelay;
    }

    public boolean isValidActivity() {
        if (this.enabled && this.leakObservation.isActive() && this.isActive) {
            return true;
        }
        JavaAgent.logger.info("Invlaid LeakObjectAnalysis Activity , index is " + this.index + ", leakObservation is:" + this.leakObservation.isActive());
        return false;
    }

    @Override
    public void run() {
        if (this.isValidActivity()) {
            this.refreshLeakHolderData();
            this.stats.clean();
            this.histogramCountForDeepSized.clear();
            this.histogramCountForShallowSized.clear();
            this.objectAnalysis();
        }
    }

    public void refreshLeakHolderData() {
        int i;
        ArrayList<ArrayList<MemoryLeaksHolder>> finalList = new ArrayList<ArrayList<MemoryLeaksHolder>>();
        HashMap<Integer, MemoryLeaksHolder> finalMap = new HashMap<Integer, MemoryLeaksHolder>();
        this.leakObservation.evacuateObservationData(finalList);
        for (i = 0; i < finalList.size(); ++i) {
            ArrayList<MemoryLeaksHolder> obj = finalList.get(i);
            for (int j = 0; j < obj.size(); ++j) {
                MemoryLeaksHolder wrapperObj = obj.get(j);
                Object liveObj = wrapperObj.getObject().get();
                if (liveObj == null) continue;
                int hash = System.identityHashCode(liveObj);
                finalMap.put(hash, wrapperObj);
            }
        }
        for (i = this.index; i < this.liveObjectSeries.size(); ++i) {
            int hash;
            Object objectRef;
            MemoryLeaksHolder memoryHolder = this.liveObjectSeries.get(i);
            if (memoryHolder == null || (objectRef = memoryHolder.getObject().get()) == null || !finalMap.containsKey(hash = System.identityHashCode(objectRef))) continue;
            finalMap.remove(hash);
        }
        Collection validateObjects = finalMap.values();
        this.liveObjectSeries.addAll(validateObjects);
    }

    public void objectAnalysis() {
        for (int i = this.index; i < this.liveObjectSeries.size(); ++i) {
            this.index = i + 1;
            MemoryLeaksHolder currentObj = this.liveObjectSeries.get(i);
            this.liveObjectSeries.set(i, null);
            Object actualObj = currentObj.getObject().get();
            try {
                if (actualObj != null && !this.objectMon.isObjectAlreadyTracked(actualObj)) {
                    this.analyzeObjectData(currentObj, actualObj);
                }
            }
            catch (Exception e) {
                JavaAgent.logger.fatal(" Exception occurred in  objectAnalysis : ", e);
            }
            if (this.stats.timeTaken > (long)LeakDetectionConfig.max_time_for_analyzer_to_spend_in_task_in_millis) break;
            if (this.enabled) continue;
            return;
        }
        this.logSummaryData();
        if (!this.leakObservation.isCropperProcessing() && this.index == this.liveObjectSeries.size()) {
            this.finishAll();
        } else {
            JavaAgent.logger.fatal(" this.leakObservation.isCropperProcessing() : " + this.leakObservation.isCropperProcessing() + " index " + this.index + " size " + this.liveObjectSeries.size());
        }
    }

    void incrementHistogram(String clzName, boolean isShallow) {
        if (isShallow) {
            Integer count = this.histogramCountForShallowSized.get(clzName);
            if (count == null) {
                count = new Integer(1);
                this.histogramCountForShallowSized.put(clzName, count);
            } else {
                this.histogramCountForShallowSized.put(clzName, new Integer(count + 1));
            }
        } else {
            Integer count = this.histogramCountForDeepSized.get(clzName);
            if (count == null) {
                count = new Integer(1);
                this.histogramCountForDeepSized.put(clzName, count);
            } else {
                this.histogramCountForDeepSized.put(clzName, new Integer(count + 1));
            }
        }
    }

    void analyzeObjectData(MemoryLeaksHolder leakHolder, Object obj) {
        StatsHolder statsHolder;
        String type = null;
        if (CalculatorUtil.unSupportedSizeMethodClasses(obj.getClass().getName())) {
            JavaAgent.logger.warn("Unsupported collection exists (Size method)  with  class name " + obj.getClass().getName());
        }
        int elementsCount = 0;
        long evalTimestamp = System.currentTimeMillis();
        if (obj instanceof Collection) {
            type = "collection";
            elementsCount = CalculatorUtil.getCollectionSize((Collection)obj);
            this.incrementHistogram(obj.getClass().getName(), true);
            statsHolder = this.stats;
            statsHolder.shallowSizeEvaluatedCollections = statsHolder.shallowSizeEvaluatedCollections + 1;
        } else if (obj instanceof Map) {
            type = "map";
            elementsCount = CalculatorUtil.getMapSize((Map)obj);
            this.incrementHistogram(obj.getClass().getName(), true);
            statsHolder = this.stats;
            statsHolder.shallowSizeEvaluatedCollections = statsHolder.shallowSizeEvaluatedCollections + 1;
        }
        if (elementsCount > this.stats.maxElements) {
            this.stats.maxElements = elementsCount;
            this.stats.maxElementsStr = obj.getClass().getName();
            this.stats.hashMaxElements = System.identityHashCode(obj);
        }
        statsHolder = this.stats;
        statsHolder.timeTaken = statsHolder.timeTaken + (System.currentTimeMillis() - evalTimestamp);
        if (elementsCount > LeakDetectionConfig.minimum_elements_to_deep_size_collection) {
            this.minElementsQualification(obj, elementsCount, type, leakHolder);
        }
    }

    private void minElementsQualification(Object obj, int elementsCount, String type, MemoryLeaksHolder leakHolder) {
        long evalTimestamp = System.currentTimeMillis();
        long deepSize = LeakDetectionConfig.memoryCalc.objectDeepSize(obj);
        StatsHolder statsHolder = this.stats;
        statsHolder.timeTaken = statsHolder.timeTaken + (System.currentTimeMillis() - evalTimestamp);
        statsHolder = this.stats;
        statsHolder.deepSizeEvaluatedCollections = statsHolder.deepSizeEvaluatedCollections + 1;
        this.incrementHistogram(obj.getClass().getName(), false);
        if (deepSize > this.stats.maxDeepSize) {
            this.stats.elementsCountDeepSizeObj = elementsCount;
            this.stats.maxDeepSizeStr = obj.getClass().getName();
            this.stats.hashMaxDeepSize = System.identityHashCode(obj);
            this.stats.maxDeepSize = deepSize;
        }
        if (deepSize > (long)LeakDetectionConfig.minimum_size_for_qualifying_bytes) {
            String formattedSize = CalculatorUtil.formatInput(deepSize);
            long age = evalTimestamp - leakHolder.getCreationTime();
            this.minimumDeepSizeQualification(obj, elementsCount, type, age, leakHolder);
        }
    }

    private void minimumDeepSizeQualification(Object obj, int noOfElements, String type, long age, MemoryLeaksHolder leakHolder) {
        int hashid = System.identityHashCode(obj);
        ObjectDetails objectDetails = new ObjectDetails(hashid, obj.getClass().getName(), age, obj, leakHolder.getCreationTime(), noOfElements, LeakDetectionConfig.memoryCalc.constructAndGetHistogram(), type);
        boolean isAdded = this.objectMon.monitorObjectSize(objectDetails);
        ArrayList<String> params = new ArrayList<String>();
        params.add(objectDetails.toString());
        if (isAdded) {
            String msg = "The collection " + objectDetails + "is qualified for monitoring";
            JavaAgent.logger.warn(msg);
            this.eventSender.addDataEvent(objectDetails);
            this.eventSender.addUiEvent(hashid, "apminsight.memoryleaks.qualified.collection", params);
        } else {
            String msg = "The collection " + objectDetails + "is qualified for monitoring but exception occured while monitoring";
            JavaAgent.logger.warn(msg);
            this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.qualified.collection.exception", params);
        }
    }

    private void logSummaryData() {
        this.getShallowSizeStats();
        this.getDeepSizeStats();
    }

    private void getShallowSizeStats() {
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.stats.shallowSizeEvaluatedCollections > 0) {
            params.add(this.stats.shallowSizeEvaluatedCollections);
            params.add(this.stats.maxElementsStr);
            params.add(this.stats.maxElements);
            params.add(this.stats.hashMaxElements);
            this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.shallow", params);
        } else {
            params.add(this.stats.shallowSizeEvaluatedCollections);
            this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.shallow.empty", params);
        }
    }

    private void getDeepSizeStats() {
        ArrayList<Object> params = new ArrayList<Object>();
        if (this.stats.deepSizeEvaluatedCollections > 0) {
            params.add(this.stats.deepSizeEvaluatedCollections);
            params.add(this.stats.maxDeepSizeStr);
            params.add(this.stats.maxDeepSize);
            params.add(this.stats.elementsCountDeepSizeObj);
            params.add(this.stats.hashMaxDeepSize);
            this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.deep", params);
        } else {
            params.add(this.stats.deepSizeEvaluatedCollections);
            this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.deep.empty", params);
        }
    }

    public void finishAll() {
        JavaAgent.logger.info("Stopping LeakObjectAnalysis: " + this.analyzerFuture);
        if (this.analyzerFuture != null) {
            this.enabled = false;
            this.isActive = false;
            this.analyzerFuture.cancel(true);
            this.leakObservation.finishFromAnalyzer();
        }
        this.eventSender.addUiEvent(0L, "apminsight.memoryleaks.analysis.finish");
    }

    private static class StatsHolder {
        private long timeTaken = 0L;
        private long maxDeepSize = 0L;
        private String maxDeepSizeStr = null;
        private int hashMaxDeepSize = 0;
        private int elementsCountDeepSizeObj = 0;
        private int maxElements = 0;
        private String maxElementsStr = null;
        private int hashMaxElements = 0;
        private int deepSizeEvaluatedCollections = 0;
        private int shallowSizeEvaluatedCollections = 0;

        private StatsHolder() {
        }

        private void clean() {
            this.timeTaken = 0L;
            this.maxElements = 0;
            this.maxElementsStr = null;
            this.hashMaxElements = 0;
            this.maxDeepSize = 0L;
            this.maxDeepSizeStr = null;
            this.hashMaxDeepSize = 0;
            this.elementsCountDeepSizeObj = 0;
            this.deepSizeEvaluatedCollections = 0;
            this.shallowSizeEvaluatedCollections = 0;
        }
    }
}

