/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.metrics.ResponseTimeMetric;
import com.manageengine.apminsight.agent.tracing.exception.ErrorThrowable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ExceptionMetric
extends ResponseTimeMetric {
    private static final int MAX_SIZE = 20;
    protected Set<ErrorThrowable> exceptions = new HashSet<ErrorThrowable>(0){

        @Override
        public boolean add(ErrorThrowable pThrowable) {
            try {
                if (pThrowable == null) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.size() >= 20) {
                JavaAgent.logger.debug("ExceptionMetric reached max size: 20");
                return false;
            }
            return super.add(pThrowable);
        }
    };

    public void recordExceptionData(ErrorThrowable pointcutThrowable) {
        this.exceptions.add(pointcutThrowable);
    }

    public void recordExceptionData(ExceptionMetric exceptionMetric) {
        this.exceptions.addAll(exceptionMetric.exceptions);
    }

    protected Map<String, Integer> getExceptionMetricDataInMap() {
        HashMap<String, Integer> metricData = new HashMap<String, Integer>(0){

            @Override
            public Integer put(String c, Integer i) {
                if (c == null) {
                    return -1;
                }
                Integer old = super.put(c = c.trim(), i);
                if (old != null) {
                    super.put(c, i + old);
                }
                return -1;
            }
        };
        for (ErrorThrowable pThrowable : this.exceptions) {
            metricData.put(pThrowable.getThrowableClass(), 1);
        }
        return metricData;
    }
}

