/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics;

import com.manageengine.apminsight.agent.metrics.ApdexMetric;
import com.manageengine.apminsight.agent.metrics.AppParamMetric;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.JvmMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.metrics.ResponseTimeMetric;

public enum MetricType {
    APDEX("apdex"){

        @Override
        public MetricData createMetricData() {
            return new ApdexMetric();
        }
    }
    ,
    BACKGROUND("bckgrnd"){

        @Override
        public MetricData createMetricData() {
            return new ComponentMetric();
        }
    }
    ,
    RESPONSETIME("time"){

        @Override
        public MetricData createMetricData() {
            return new ResponseTimeMetric();
        }
    }
    ,
    APP_PARAMS("appparam"){

        @Override
        public MetricData createMetricData() {
            return new AppParamMetric();
        }
    }
    ,
    JVM("jvm"){

        @Override
        public MetricData createMetricData() {
            return new JvmMetric();
        }
    };

    private final String displayName;

    private MetricType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public MetricData createMetricData() {
        return null;
    }
}

