/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.metrics.store;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.metric.MetricConstants;
import com.manageengine.apminsight.agent.metrics.ApdexMetric;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.GlobalMetrics;
import com.manageengine.apminsight.agent.metrics.Metric;
import com.manageengine.apminsight.agent.metrics.MetricName;
import com.manageengine.apminsight.agent.metrics.MetricType;
import com.manageengine.apminsight.agent.metrics.store.AbstractMetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.List;

public class InstanceMetricConstructor
implements MetricConstants {
    public static MetricStore construct(MetricStore metricStore) {
        AbstractMetricStore aMetricStore = (AbstractMetricStore)metricStore;
        InstanceMetricConstructor.removeAlreadyExistingGlobalMetricsIfAny(aMetricStore);
        InstanceMetricConstructor.constructGlobalApdexMetric(aMetricStore);
        InstanceMetricConstructor.constructGlobalBackgroundMetric(aMetricStore);
        return aMetricStore;
    }

    private static AbstractMetricStore constructGlobalApdexMetric(AbstractMetricStore aMetricStore) {
        List<Metric> apdexRawMetrics = aMetricStore.getApdexMetrics();
        if (apdexRawMetrics.isEmpty()) {
            return aMetricStore;
        }
        for (Metric metric : apdexRawMetrics) {
            ApdexMetric apdexRawMetric = (ApdexMetric)metric.getMetricData();
            ApdexMetric apdexMetric = (ApdexMetric)aMetricStore.getMetric(new Metric(new MetricName(apdexRawMetric.getContextName(), "", "apdex"){

                @Override
                public String getNameSpace() {
                    return this.getContextName();
                }
            }, MetricType.APDEX), true).getMetricData();
            apdexMetric.setContextName(apdexRawMetric.getContextName());
            apdexMetric.recordData(apdexRawMetric);
            apdexMetric.recordHTTPData(apdexRawMetric);
            apdexMetric.recordComponentData(apdexRawMetric);
            apdexMetric.recordLogCountData(apdexRawMetric);
        }
        JavaAgent.logger.log(Level.DEBUG, "Instance level Apdex Metric updated successfully in MetricStore: {}", (Object)aMetricStore.getName());
        return aMetricStore;
    }

    private static AbstractMetricStore constructGlobalBackgroundMetric(AbstractMetricStore aMetricStore) {
        List<Metric> bckgrndRawMetrics = aMetricStore.getBackgroundMetrics();
        if (bckgrndRawMetrics.isEmpty()) {
            return aMetricStore;
        }
        ComponentMetric componentMetric = (ComponentMetric)aMetricStore.getMetric(GlobalMetrics.I_BCKGRND, true).getMetricData();
        for (Metric metric : bckgrndRawMetrics) {
            ComponentMetric rawMetric = (ComponentMetric)metric.getMetricData();
            componentMetric.recordComponentData(rawMetric);
            componentMetric.recordLogCountData(rawMetric);
            componentMetric.recordData(rawMetric);
        }
        JavaAgent.logger.log(Level.DEBUG, "Instance level Background Metric updated successfully in MetricStore: {}", (Object)aMetricStore.getName());
        return aMetricStore;
    }

    private static void removeAlreadyExistingGlobalMetricsIfAny(AbstractMetricStore aMetricStore) {
        List<Metric> apdexRawMetrics = aMetricStore.getApdexMetrics();
        for (Metric metric : apdexRawMetrics) {
            if (metric.getMetricName().getNameSpace().startsWith("transaction/http/")) continue;
            aMetricStore.removeApdexMetric(metric.getMetricName().getNameSpace());
        }
        aMetricStore.removeBackgroundMetric(GlobalMetrics.I_BCKGRND.getMetricName().getNameSpace());
    }
}

