/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.JavaAgentConstants;
import com.manageengine.apminsight.agent.config.AbstractSequenceConfig;
import com.manageengine.apminsight.agent.config.AgentDebugModeConfig;
import com.manageengine.apminsight.agent.config.ApplicationConfig;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.config.KeyTransactionUtil;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.metrics.Metric;
import com.manageengine.apminsight.agent.metrics.ResponseTimeMetric;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;
import com.manageengine.apminsight.agent.sequence.SequenceBag;
import com.manageengine.apminsight.agent.sequence.SequenceFilterByUrl;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceHeaderQueue;
import com.manageengine.apminsight.agent.sequence.SequenceType;
import com.manageengine.apminsight.agent.sequence.process.AsyncSequenceProcessor;
import com.manageengine.apminsight.agent.service.profiler.TransactionProfilerService;
import com.manageengine.apminsight.agent.tracing.exception.ErrorRecord;
import com.manageengine.apminsight.agent.tracing.exception.ErrorThrowable;
import com.manageengine.apminsight.agent.tracing.exception.PointcutErrorRecord;
import com.manageengine.apminsight.agent.trackers.AbstractRootTracker;
import com.manageengine.apminsight.agent.trackers.AbstractTracker;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.trackers.RootTracker;
import com.manageengine.apminsight.agent.trackers.Tracker;
import com.manageengine.apminsight.agent.trackers.VoidTracker;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.trackers.db.AbstractDBTracker;
import com.manageengine.apminsight.agent.trackers.db.QueryHolder;
import com.manageengine.apminsight.agent.trackers.micronaut.MicronautNettyTracker;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SequenceSpace
implements JavaAgentConstants {
    public static final ThreadLocal<SequenceSpace> SEQUENCE_BOOK = new ThreadLocal<SequenceSpace>(){

        @Override
        protected SequenceSpace initialValue() {
            return new SequenceSpace();
        }
    };
    private RootTracker tRoot;
    private AbstractTracker tOpen = null;
    private AbstractTracker tClosed;
    private short tCount = 0;
    public byte listenBlockFlag = (byte)-1;
    private QueryHolder queryHolder;
    private SequenceType seqType;
    private ContextInfo context;
    private ApplicationConfig appConfig;
    private AbstractSequenceConfig seqConfig;
    private SequenceBag<ErrorRecord> errorRecordBag;
    private Map<String, List<String>> customParams = null;
    private AbstractDBTracker recentDelayedSql;
    private long seqThreadTotalCpuTime = -1L;
    private long seqThreadMemoryAlloc = -1L;
    private int[] trackersCount = new int[]{0, 0, 0};
    private Integer trackerDropThreshold;
    private List<CallerAsyncRootTracker> asyncTrackerBag;
    private boolean bypassSampling;

    private SequenceSpace() {
        this.tRoot = this.createSentinalTracker();
        this.tClosed = (AbstractTracker)((Object)this.tRoot);
        this.errorRecordBag = new SequenceBag(20);
    }

    public Tracker transformTracker(Tracker tracker) {
        int index;
        if (tracker == null || tracker instanceof VoidTracker) {
            if (this.tCount == 0) {
                this.closeSeqSpace();
            }
            return tracker;
        }
        if (this.tClosed == this.tRoot) {
            if (!(tracker instanceof RootTracker)) {
                this.closeSeqSpace();
                return null;
            }
            this.tRoot = (RootTracker)tracker;
            boolean isWebSeq = tracker instanceof WebSeqRootTracker;
            this.seqType = isWebSeq ? SequenceType.WEB_HTTP : SequenceType.BACKGROUND;
            this.context = isWebSeq ? ContextInfoManager.getInstance().getContextInfoOrDefault(((WebSeqRootTracker)this.tRoot).getContextPath()) : ContextInfoManager.getInstance().getDefaultContextInfo();
            this.appConfig = KeyTransactionUtil.ifKeyTxnGetConfig(this.tRoot.getSequenceName());
            if (this.appConfig == null) {
                this.appConfig = this.context.getConfig();
            }
            this.seqConfig = isWebSeq ? this.appConfig.getWebSeqConfig() : this.appConfig.getBackgroundSeqConfig();
            this.updateDiscardFlag();
            this.recordSeqThreadTotalCpuTime();
            this.recordSeqThreadMemoryAlloc();
            this.trackerDropThreshold = JavaAgent.getInstance().getAgentConfig().getDropThreshold(this.tRoot.getSequenceNameSpace());
            this.trackerDropThreshold = this.trackerDropThreshold == null ? this.seqConfig.getTrackerDropTreshold() : this.trackerDropThreshold.intValue();
        }
        int n = index = tracker instanceof AbstractDBTracker ? 2 : (tracker.getPointcutProperties().getComponent().isExternal() ? 1 : 0);
        this.trackersCount[n] = this.trackersCount[n] + 1;
        if (this.listenBlockFlag == 3) {
            return null;
        }
        return this.listenBlockFlag == 2 && index == 0 ? null : this.attachTracker((DefaultTracker)tracker);
    }

    private Tracker attachTracker(DefaultTracker tracker) {
        TransactionProfilerService.addTxnToProfiler(Thread.currentThread().getId());
        if (this.tClosed != null) {
            tracker.sibling = this.tClosed;
            this.tClosed.sibling = tracker;
            this.tOpen = tracker;
            this.tClosed = null;
        } else {
            if (tracker.equals(this.tOpen) || this.tOpen.isLeafTracker()) {
                return null;
            }
            this.tOpen.child = tracker;
            tracker.sibling = this.tOpen;
            this.tOpen = tracker;
        }
        this.tCount = (short)(this.tCount + 1);
        this.checkAndArrestSequence();
        return tracker;
    }

    public void cleanAndUpdate(Tracker tracker) {
        if (tracker instanceof VoidTracker) {
            return;
        }
        if (tracker instanceof MicronautNettyTracker && !((MicronautNettyTracker)tracker).isTrackingComplete()) {
            this.dropTracker((AbstractTracker)tracker);
            return;
        }
        if (tracker instanceof CallerAsyncRootTracker && tracker != this.tRoot) {
            if (this.asyncTrackerBag == null) {
                this.asyncTrackerBag = new ArrayList<CallerAsyncRootTracker>(20);
            }
            this.asyncTrackerBag.add((CallerAsyncRootTracker)tracker);
        }
        AbstractTracker t = (AbstractTracker)tracker;
        tracker = null;
        if (t instanceof AbstractDBTracker) {
            AbstractTracker leafTracker = AbstractTracker.getLeafTracker(t);
            if (leafTracker != t && t.getClass().equals(leafTracker.getClass())) {
                if (t.sibling.sibling == t) {
                    t.sibling.sibling = leafTracker;
                } else {
                    t.sibling.child = leafTracker;
                }
                leafTracker.sibling = t.sibling;
                t = leafTracker;
                this.tCount = (short)(this.tCount - 1);
                this.trackersCount[2] = this.trackersCount[2] - 1;
            } else {
                t.child = null;
            }
        }
        if (!(t == this.tRoot || t.getDuration() > this.trackerDropThreshold || t.getPointcutProperties().getComponent().isExternal() || t.isErroneous() || t instanceof CallerAsyncRootTracker)) {
            this.dropTracker(t);
        } else {
            this.tClosed = t;
            t.sibling = null;
            this.tOpen = null;
            if (t == this.tRoot) {
                boolean pass;
                boolean bl = pass = this.listenBlockFlag < 1 || this.tCount > 1;
                if (this.seqType == SequenceType.BACKGROUND) {
                    boolean bl2 = pass = pass && (this.tCount > 1 || this.tRoot.getPointcutProperties().getComponent().isExternal());
                }
                if (pass) {
                    SequenceHeader seqHeader = new SequenceHeader();
                    if (this.seqThreadTotalCpuTime != -1L) {
                        long initalTotalCpuTime = this.seqThreadTotalCpuTime;
                        if (this.recordSeqThreadTotalCpuTime() != -1L) {
                            this.seqThreadTotalCpuTime -= initalTotalCpuTime;
                            seqHeader.setSeqCpuTimeInNanoSec(this.seqThreadTotalCpuTime);
                        }
                    }
                    if (this.seqThreadMemoryAlloc != -1L) {
                        long initalTotalMemoryAlloc = this.seqThreadMemoryAlloc;
                        if (this.recordSeqThreadMemoryAlloc() != -1L) {
                            seqHeader.setSeqMemoryAllocInBytes(this.seqThreadMemoryAlloc - initalTotalMemoryAlloc);
                        }
                    }
                    Thread currThread = Thread.currentThread();
                    TransactionProfilerService.removeTxnFromProfiler(currThread.getId());
                    seqHeader.setUnnormalizedSeqNameSpace(this.tRoot.getSequenceNameSpace());
                    seqHeader.setSequenceType(this.seqType);
                    seqHeader.setApplicationConfig(this.appConfig);
                    seqHeader.setErrorRecords(this.errorRecordBag);
                    seqHeader.setRootTracker(this.tRoot);
                    seqHeader.setSequenceThreadId(currThread.getId());
                    seqHeader.setSequenceThreadName(currThread.getName());
                    seqHeader.setRecentDelayedSql(this.recentDelayedSql);
                    seqHeader.setTrackersCount(this.trackersCount);
                    seqHeader.setCustomParams(this.customParams);
                    seqHeader.setAsyncTrackerBag(this.asyncTrackerBag);
                    seqHeader.setContextName(this.seqType == SequenceType.WEB_HTTP ? ((WebSeqRootTracker)this.tRoot).getContextPath() : this.context.getContextName());
                    pass = seqHeader.isAsyncSequence() ? AsyncSequenceProcessor.addToQueue(seqHeader) : SequenceHeaderQueue.add(seqHeader);
                }
                this.closeSeqSpace();
            }
        }
    }

    public void cleanAndUpdateOnTrackerError(Tracker tracker) {
        if (tracker instanceof VoidTracker) {
            return;
        }
        this.dropTracker((AbstractTracker)tracker);
    }

    void dropTracker(AbstractTracker t) {
        if (t == this.tRoot) {
            this.closeSeqSpace();
            t = null;
            return;
        }
        AbstractTracker temp = t.child;
        AbstractTracker extClosed = null;
        while (temp != null) {
            extClosed = temp;
            temp = temp.sibling;
        }
        temp = null;
        AbstractTracker nominee = t.sibling;
        if (nominee.sibling == t) {
            this.tClosed = t.child == null ? nominee : extClosed;
            nominee.sibling = t.child;
            t = null;
        } else {
            this.tOpen = t.child == null ? nominee : extClosed;
            this.tClosed = t.child == null ? null : extClosed;
            nominee.child = t.child;
            t = null;
        }
        this.listenBlockFlag = 0;
        this.tCount = (short)(this.tCount - 1);
        this.trackersCount[0] = this.trackersCount[0] - 1;
    }

    protected void updateDiscardFlag() {
        if (this.context != null && !this.context.isActive()) {
            this.listenBlockFlag = 1;
        } else if (!this.seqConfig.isTrackingEnabled()) {
            this.listenBlockFlag = 1;
        } else if (SequenceFilterByUrl.isSkip(this.tRoot.getSequenceName())) {
            this.listenBlockFlag = 1;
        } else if (JavaAgent.getInstance().getAgentConfig().isDebugModeEnabled() && AgentDebugModeConfig.isSkip(this.tRoot.getSequenceName())) {
            this.listenBlockFlag = 1;
        } else if (!this.bypassSampling) {
            this.updateDiscardFlagBySamplingFactor();
        }
    }

    private void updateDiscardFlagBySamplingFactor() {
        short samplingFactor = this.seqConfig.getSamplingFactor();
        String seqNameSpace = this.tRoot.getSequenceNameSpace();
        if (samplingFactor > 1) {
            Metric metric = null;
            metric = this.seqType == SequenceType.WEB_HTTP ? MetricStoreController.getMetricStore().findApdexMetric(seqNameSpace) : MetricStoreController.getMetricStore().findBackgroundMetric(seqNameSpace);
            if (metric != null) {
                ResponseTimeMetric rtMetric = (ResponseTimeMetric)metric.getMetricData();
                if (rtMetric.actualCount.getAndIncrement() % samplingFactor == 0) {
                    this.listenBlockFlag = 0;
                    JavaAgent.logger.log(Level.TRACE, "Sequence: {} selected to be listened. sampling value used: {}", seqNameSpace, samplingFactor);
                } else {
                    this.listenBlockFlag = 1;
                    JavaAgent.logger.log(Level.DEBUG, "Sequence: {} DISCARDED based on sampling factor value: {}", seqNameSpace, samplingFactor);
                }
            }
        }
    }

    protected void closeSeqSpace() {
        this.tRoot = null;
        this.tOpen = null;
        this.tClosed = null;
        this.queryHolder = null;
        SEQUENCE_BOOK.remove();
    }

    public QueryHolder getQueryHolder() {
        if (this.queryHolder == null) {
            this.queryHolder = new QueryHolder();
        }
        return this.queryHolder;
    }

    protected void checkAndArrestSequence() {
        if (this.tCount == JavaAgentConfig.maxTrackerInSeq) {
            this.listenBlockFlag = (byte)2;
            JavaAgent.logger.debug("[SequenceSpace] Sequence: " + this.tRoot.getSequenceNameSpace() + " is blocked to track further. Seq.instore tracker size: " + JavaAgentConfig.maxTrackerInSeq);
        } else if (this.tCount == 2 * JavaAgentConfig.maxTrackerInSeq) {
            this.listenBlockFlag = (byte)3;
        }
    }

    private RootTracker createSentinalTracker() {
        return new AbstractRootTracker(null, null, null){

            @Override
            public String getSequenceNameSpace() {
                return null;
            }

            @Override
            protected String assignSequenceName() {
                return null;
            }
        };
    }

    public RootTracker getRootTracker() {
        return this.tRoot;
    }

    public SequenceBag<ErrorRecord> getLogRecordBag() {
        return this.errorRecordBag;
    }

    public int currentTrackersCount() {
        return this.tCount;
    }

    public Tracker getCurrentOpenTracker() {
        return this.tOpen;
    }

    private long recordSeqThreadTotalCpuTime() {
        if (this.seqConfig.isTransactionCpuTimeEnabled()) {
            this.seqThreadTotalCpuTime = ThreadMxBeanUtil.getCurrThreadTotalCpuTimeInNanoSec();
        }
        return this.seqThreadTotalCpuTime;
    }

    private long recordSeqThreadMemoryAlloc() {
        if (this.seqConfig.isTransactionMemoryAllocEnabled()) {
            this.seqThreadMemoryAlloc = ThreadMxBeanUtil.getCurrThreadAllocatedBytes();
        }
        return this.seqThreadMemoryAlloc;
    }

    public void markSequenceAsErr(Throwable th) {
        if (th != null && !th.getClass().getName().matches(this.appConfig.excludeExceptionsRegex)) {
            PointcutErrorRecord errorRecord = new PointcutErrorRecord(System.currentTimeMillis(), th.getMessage(), new ErrorThrowable(th));
            this.errorRecordBag.add(errorRecord);
        }
    }

    public void setRecentDelayedSql(AbstractDBTracker abstractDBTracker) {
        this.recentDelayedSql = abstractDBTracker;
    }

    public void addCustomParameter(String key, String value) {
        List<String> values;
        if (this.customParams == null) {
            this.customParams = new HashMap<String, List<String>>();
        }
        if ((values = this.customParams.get(key)) == null) {
            values = new ArrayList<String>();
            values.add(value);
            this.customParams.put(key, values);
        } else if (values.size() < 10) {
            values.add(value);
        }
    }

    public void setTransactionName(String customTxnName) {
        ((AbstractRootTracker)this.tRoot).setCustomSequenceName(customTxnName);
    }

    public ApplicationConfig getConfig() {
        return this.appConfig;
    }

    public void setBypassSampling(boolean bypassSampling) {
        this.bypassSampling = bypassSampling;
    }
}

