/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.components.Component;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.metric.MetricConstants;
import com.manageengine.apminsight.agent.sequence.SequenceBag;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.tracing.StackTrace;
import com.manageengine.apminsight.agent.tracing.exception.ErrorRecord;
import com.manageengine.apminsight.agent.tracing.exception.ErrorThrowable;
import com.manageengine.apminsight.agent.trackers.AbstractTracker;
import com.manageengine.apminsight.agent.trackers.RootTracker;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.json.simple.JSONArray;
import com.manageengine.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class SequenceTrace
implements JSONStreamAware,
MetricConstants {
    private final Map<String, Object> sequenceInfo = new HashMap<String, Object>(8, 1.0f);
    private Map<String, Map<Component, Integer>> extComponentsCount = new HashMap<String, Map<Component, Integer>>(2);
    private Set<String> db_operations = new HashSet<String>();
    private int distributedTraceCount = 0;
    private int duration;
    private int traceReason;
    private SequenceTraceItem rootTraceItem;
    private String contextName;
    private int[] newDropThresholdValues = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    private boolean calculateNewDropThreshold = false;

    public SequenceTrace(SequenceHeader sh, int traceReason) {
        this.traceReason = traceReason;
        this.duration = sh.getRootTracker().getDuration();
        this.calculateNewDropThreshold = JavaAgent.getInstance().getAgentConfig().isAutoDetectDropThresholdEnabled() && sh.getTotalTrackersCount() >= JavaAgentConfig.maxTrackerInSeq;
        this.contextName = sh.getContextName();
        this.constructSeqTrace(sh);
        if (this.calculateNewDropThreshold && (double)this.newDropThresholdValues[1] < (double)this.duration * 0.02) {
            JavaAgent.getInstance().getAgentConfig().setDropThreshold(sh.getUnnormalizedSeqNameSpace(), this.newDropThresholdValues[1]);
            JavaAgent.logger.log(Level.TRACE, "{} assigned a new drop threshold of {}", sh.getRootTracker().getSequenceNameSpace(), this.newDropThresholdValues[1]);
            this.newDropThresholdValues = null;
        }
        if (JavaAgent.logger.isLoggable(Level.DEBUG)) {
            JavaAgent.logger.debug(sh.getRootTracker().getSequenceNameSpace() + " trace reason: " + traceReason);
        }
    }

    public void constructSeqTrace(SequenceHeader sh) {
        SequenceBag<ErrorRecord> logRecords;
        RootTracker rootTracker = sh.getRootTracker();
        this.sequenceInfo.put("s_time", rootTracker.getStartTime());
        this.sequenceInfo.put("t_name", rootTracker.getSequenceNameSpace());
        this.sequenceInfo.put("exact_url", rootTracker.getUnnormalizedSeqName());
        this.sequenceInfo.put("r_time", rootTracker.getDuration());
        this.sequenceInfo.put("thread_name", sh.getSequenceThreadName());
        this.sequenceInfo.put("thread_id", sh.getSequenceThreadId());
        if (rootTracker.isErroneous()) {
            this.sequenceInfo.put("err_st", new StackTrace(rootTracker.getErrorCause().getStackTrace()));
        }
        if ((logRecords = sh.getErrorRecords()) != null && logRecords.size() > 0) {
            this.sequenceInfo.put("loginfo", this.constructLogInfo(logRecords));
        }
        this.sequenceInfo.put("cputime", TimeUnit.NANOSECONDS.toMillis(sh.getSeqCpuTimeInNanoSec()));
        this.sequenceInfo.put("memalloc", sh.getSeqMemoryAllocInBytes() / 1024L);
        this.sequenceInfo.putAll(rootTracker.getContextualMetrics());
        Integer trackerDropThreshold = JavaAgent.getInstance().getAgentConfig().getDropThreshold(sh.getUnnormalizedSeqNameSpace());
        this.sequenceInfo.put("drop_threshold", trackerDropThreshold != null ? trackerDropThreshold.intValue() : sh.getSequenceConfig().getTrackerDropTreshold());
        this.rootTraceItem = this.formTreeAndGetRoot(rootTracker);
        this.addTrackersCount(sh);
        if (!this.extComponentsCount.isEmpty()) {
            this.sequenceInfo.put("ext_components", this.extComponentsCount);
        }
        if (!this.db_operations.isEmpty()) {
            this.sequenceInfo.put("db_opn", new ArrayList<String>(this.db_operations));
        }
        if (this.distributedTraceCount != 0) {
            this.sequenceInfo.put("dt_count", this.distributedTraceCount);
        }
        if (sh.getCustomParams() != null) {
            this.sequenceInfo.put("custom_params", sh.getCustomParams());
        }
    }

    private SequenceTraceItem formTreeAndGetRoot(RootTracker t) {
        ArrayList<SequenceTraceItem> children = new ArrayList<SequenceTraceItem>(1);
        this.buildTrace((AbstractTracker)((Object)t), children);
        return (SequenceTraceItem)children.get(0);
    }

    private int buildTrace(AbstractTracker t, List<SequenceTraceItem> children) {
        int siblingsDuration = 0;
        while (t != null) {
            ArrayList<SequenceTraceItem> childrn = new ArrayList<SequenceTraceItem>(2);
            int childDuration = this.buildTrace(t.child, childrn);
            Component component = t.getPointcutProperties().getComponent();
            HashMap<String, Object> additionalDetails = new HashMap<String, Object>();
            if (t.getErrorCause() != null && (t.child == null || t.child.getErrorCause() != t.getErrorCause())) {
                additionalDetails.put("exception_st", new StackTrace(t.getErrorCause().getStackTrace()));
            }
            SequenceTraceItem tItem = new SequenceTraceItem(t.getStartTime(), t.getTrackerSignature(), component.toString(), t.getDuration(), t.getMoreData(additionalDetails));
            Set db_opns = (Set)additionalDetails.remove("db_opn");
            if (db_opns != null) {
                this.db_operations.addAll(db_opns);
            }
            if (additionalDetails.containsKey("dtdata")) {
                ++this.distributedTraceCount;
            }
            if (component.isExternal()) {
                String componentStatus = t.getErrorCause() == null ? "success" : "fail";
                HashMap<Component, Integer> componentCount = this.extComponentsCount.get(componentStatus);
                if (componentCount == null) {
                    componentCount = new HashMap<Component, Integer>(){

                        @Override
                        public Integer put(Component c, Integer i) {
                            Integer old = super.put(c, i);
                            if (old != null) {
                                super.put(c, old + i);
                            }
                            return old;
                        }
                    };
                    this.extComponentsCount.put(componentStatus, (Map<Component, Integer>)componentCount);
                }
                componentCount.put(component, 1);
            }
            if (childrn.isEmpty()) {
                tItem.children = null;
            } else {
                float apdex = ContextInfoManager.getInstance().getContextInfoOrDefault(this.contextName).getConfig().getWebSeqConfig().getApdexThreshold();
                int uninstrumentedDuration = (int)(((SequenceTraceItem)childrn.get(0)).startTime - tItem.startTime);
                if ((float)uninstrumentedDuration >= apdex) {
                    childrn.add(0, this.getPseudoTraceItem(tItem.startTime, uninstrumentedDuration));
                    childDuration += uninstrumentedDuration;
                }
                SequenceTraceItem lastchild = (SequenceTraceItem)childrn.get(childrn.size() - 1);
                uninstrumentedDuration = (int)(tItem.startTime + (long)tItem.duration - (lastchild.startTime + (long)lastchild.duration));
                if ((float)uninstrumentedDuration >= apdex) {
                    childrn.add(this.getPseudoTraceItem(lastchild.startTime + (long)lastchild.duration, uninstrumentedDuration));
                    childDuration += uninstrumentedDuration;
                }
                tItem.children = childrn;
            }
            if (!children.isEmpty()) {
                SequenceTraceItem lastchild = children.get(children.size() - 1);
                int uninstrumentedDuration = (int)(tItem.startTime - (lastchild.startTime + (long)lastchild.duration));
                if ((float)uninstrumentedDuration >= ContextInfoManager.getInstance().getContextInfoOrDefault(this.contextName).getConfig().getWebSeqConfig().getApdexThreshold()) {
                    children.add(this.getPseudoTraceItem(lastchild.startTime + (long)lastchild.duration, uninstrumentedDuration));
                    siblingsDuration += uninstrumentedDuration;
                }
            }
            tItem.setExclusiveTime(t.getDuration() - childDuration);
            children.add(tItem);
            siblingsDuration += t.getDuration();
            if (this.calculateNewDropThreshold && !component.isExternal() && this.newDropThresholdValues[2] > t.getDuration()) {
                this.newDropThresholdValues[2] = t.getDuration();
                Arrays.sort(this.newDropThresholdValues);
            }
            t = t.sibling;
        }
        return siblingsDuration;
    }

    private void addTrackersCount(SequenceHeader sh) {
        int[] trackersCount = sh.getTrackersCount();
        if (trackersCount == null) {
            return;
        }
        StringBuilder trackerSignature = new StringBuilder();
        if (trackersCount[0] != 0) {
            trackerSignature.append("+ " + trackersCount[0] + " Method Call(s) ");
        }
        if (trackersCount[1] != 0) {
            trackerSignature.append("+ " + trackersCount[1] + " External Call(s) ");
        }
        if (trackersCount[2] != 0) {
            trackerSignature.append("+ " + trackersCount[2] + " SQL(s)");
        }
        trackerSignature.delete(0, 2);
        SequenceTraceItem traceItem = new SequenceTraceItem(this.rootTraceItem.startTime, "Total Calls: " + trackerSignature.toString(), "", this.duration, null);
        traceItem.children = new ArrayList(2);
        traceItem.children.add(this.rootTraceItem);
        this.rootTraceItem = traceItem;
    }

    private SequenceTraceItem getPseudoTraceItem(long starttime, int duration) {
        SequenceTraceItem pseudoItem = new SequenceTraceItem(starttime, "Un-Instrumented Block of code", "", duration, null);
        pseudoItem.setExclusiveTime(duration);
        return pseudoItem;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getTraceReason() {
        return this.traceReason;
    }

    public String getContextName() {
        return this.contextName;
    }

    private List output() {
        return Arrays.asList(this.sequenceInfo, this.rootTraceItem);
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(this.output(), out);
    }

    public String toString() {
        return this.output().toString();
    }

    private List<Map<String, Object>> constructLogInfo(SequenceBag<ErrorRecord> logRecords) {
        if (logRecords == null || logRecords.size() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> logInfo = new ArrayList<Map<String, Object>>();
        for (ErrorRecord logRecord : logRecords) {
            LinkedHashMap<String, Object> logRecordSplitUp = new LinkedHashMap<String, Object>(5);
            logRecordSplitUp.put("time", logRecord.getLogTime());
            logRecordSplitUp.put("level", logRecord.getErrorType());
            String logMessage = logRecord.getUserMessage();
            ErrorThrowable loggedTh = logRecord.getThrowable();
            if (loggedTh != null) {
                if (StringUtils.isEmptyString(logMessage)) {
                    logMessage = loggedTh.getThrowableLocalizedMessage();
                }
                logRecordSplitUp.put("err_clz", loggedTh.getThrowableClass());
                logRecordSplitUp.put("st", loggedTh.getStackTrace());
            }
            logRecordSplitUp.put("str", logMessage);
            if (loggedTh == null && StringUtils.isEmptyString(logMessage)) continue;
            logInfo.add(logRecordSplitUp);
        }
        return logInfo;
    }

    static class SequenceTraceItem
    implements JSONStreamAware {
        private final long startTime;
        private final String itemName;
        private final String component;
        private final int duration;
        private int exclusive;
        private final Map details;
        private List<SequenceTraceItem> children;

        public SequenceTraceItem(long startTime, String itemName, String component, int duration, Map details) {
            this.startTime = startTime;
            this.itemName = itemName;
            this.component = component;
            this.duration = duration;
            this.details = details == null || details.isEmpty() ? null : details;
        }

        public void setExclusiveTime(int exclusiveTime) {
            this.exclusive = exclusiveTime < 0 ? 0 : exclusiveTime;
        }

        @Override
        public void writeJSONString(Writer out) throws IOException {
            JSONArray.writeJSONString(this.output(), out);
        }

        private List output() {
            return Arrays.asList(this.startTime, this.itemName, this.component, this.duration, this.exclusive, this.details, this.children);
        }

        public String toString() {
            return this.output().toString();
        }
    }
}

