/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.sequence.process;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.config.AbstractSequenceConfig;
import com.manageengine.apminsight.agent.metric.TraceReason;
import com.manageengine.apminsight.agent.metrics.Metric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.metrics.MetricType;
import com.manageengine.apminsight.agent.metrics.ResponseTimeMetric;
import com.manageengine.apminsight.agent.metrics.store.MetricStore;
import com.manageengine.apminsight.agent.metrics.store.MetricStoreController;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.sequence.SequenceHeaderQueue;
import com.manageengine.apminsight.agent.sequence.SequenceTrace;
import com.manageengine.apminsight.agent.sequence.SequenceTraceStore;
import com.manageengine.apminsight.agent.sequence.SequenceType;
import com.manageengine.apminsight.agent.sequence.TransactionTraceProfile;
import com.manageengine.apminsight.agent.sequence.process.SeqMiscellaneousMetricsGenerator;
import com.manageengine.apminsight.agent.trackers.AbstractTracker;
import com.manageengine.apminsight.agent.trackers.CalleeAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.CallerAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.RootTracker;
import com.manageengine.apminsight.agent.trackers.WebSeqResponseCodeTracker;
import com.manageengine.apminsight.agent.trackers.WebSeqRootTracker;
import com.manageengine.apminsight.agent.trackers.api.CustomAPITracker;
import com.manageengine.apminsight.agent.trackers.db.DatabaseTracker;
import com.manageengine.apminsight.agent.util.LRUMap;
import com.manageengine.org.apache.logging.log4j.Level;
import java.util.HashSet;
import java.util.Set;

public class SequenceProcessor
implements Runnable {
    private boolean stopFlag = false;
    private static final short REST_AFTER = 120;
    private String currSequenceNameSpace = null;
    private Set<Integer> spanIdSet = new HashSet<Integer>();
    private TransactionTraceProfile txnTraceProfile = null;
    private static LRUMap<String, TransactionTraceProfile> txnTraceProfileHolder = null;

    @Override
    public void run() {
        JavaAgent.logger.info("SequenceProcessor " + Thread.currentThread().getName() + " started.");
        txnTraceProfileHolder = new LRUMap(150);
        int restAfter = 120;
        while (!this.stopFlag) {
            try {
                this.doProcessing();
                int n = restAfter;
                restAfter = (short)(restAfter - 1);
                if (n != 0) continue;
                Thread.sleep(1000L);
                restAfter = 120;
            }
            catch (Throwable th) {
                JavaAgent.logger.log(Level.WARN, "[SequenceProcessor]", th);
            }
        }
        JavaAgent.logger.info(Thread.currentThread().getName() + " quiting.");
    }

    private void doProcessing() throws Exception {
        int statusCode;
        SequenceHeader sh = SequenceHeaderQueue.take();
        RootTracker rootTracker = sh.getRootTracker();
        if (rootTracker == null || rootTracker instanceof CalleeAsyncRootTracker) {
            return;
        }
        if (rootTracker instanceof WebSeqResponseCodeTracker && String.valueOf(statusCode = ((WebSeqResponseCodeTracker)rootTracker).getResponseCode()).matches(sh.getApplicationConfig().getWebSeqConfig().getHTTPErrorsToIgnore())) {
            return;
        }
        this.spanIdSet.clear();
        this.currSequenceNameSpace = rootTracker.getSequenceNameSpace();
        this.txnTraceProfile = new TransactionTraceProfile();
        this.txnTraceProfile.setDuration(rootTracker.getDuration());
        MetricType metricType = sh.getSequenceType() == SequenceType.WEB_HTTP ? MetricType.APDEX : MetricType.BACKGROUND;
        MetricStore metricStore = MetricStoreController.getMetricStore();
        Metric metric = metricStore.getMetric(sh.getContextName(), this.currSequenceNameSpace, metricType.getDisplayName(), metricType, false);
        ((ResponseTimeMetric)metric.getMetricData()).setContextName(sh.getContextName());
        this.produceMetrics((AbstractTracker)((Object)rootTracker), metric.getMetricData(), sh);
        SeqMiscellaneousMetricsGenerator.produceMetrics(sh, this.txnTraceProfile, metric.getMetricData());
        if (rootTracker instanceof WebSeqResponseCodeTracker ? sh.getTotalTrackersCount() > 2 : sh.getTotalTrackersCount() > 1 || sh.isSequenceErroneous()) {
            this.produceTrace(sh);
        }
    }

    int produceMetrics(AbstractTracker tracker, MetricData metricData, SequenceHeader sh) {
        int siblingsDuration = 0;
        while (tracker != null) {
            if (!this.spanIdSet.add(tracker.getSpanID().hashCode())) {
                JavaAgent.logger.trace("Infinite loop detected. Fixing it. Txn: {}:{}", this.currSequenceNameSpace, tracker.getTrackerSignature());
                break;
            }
            int childDuration = this.produceMetrics(tracker.child, metricData, sh);
            tracker.generateMetric(sh, childDuration, metricData);
            if (!(tracker instanceof CallerAsyncRootTracker)) {
                siblingsDuration += tracker.getDuration();
            }
            if (tracker.getPointcutProperties().getComponent().isExternal()) {
                this.txnTraceProfile.incrementExtCallCount();
            }
            if (tracker instanceof DatabaseTracker) {
                this.txnTraceProfile.addSQLTime(tracker.getDuration());
            }
            if (tracker instanceof CustomAPITracker && !((CustomAPITracker)tracker).isCompleted()) {
                tracker.sibling = null;
            }
            tracker = tracker.sibling;
        }
        return siblingsDuration;
    }

    public void produceTrace(SequenceHeader sh) {
        AbstractSequenceConfig config = sh.getSequenceConfig();
        if (config.isSeqTraceEnabled()) {
            int traceReason = this.getTraceReason(sh);
            this.txnTraceProfile.setTraceReason(traceReason);
            if (traceReason != 0) {
                if (traceReason == TraceReason.SYNTHETIC_MONITORING_TRACE.getValue()) {
                    SequenceTraceStore.constructTraceAndPut(this.currSequenceNameSpace + Math.random(), sh, traceReason, true);
                } else if (config.canTraceDuplicate()) {
                    SequenceTraceStore.constructTraceAndPut(this.currSequenceNameSpace + Math.random(), sh, traceReason);
                } else {
                    TransactionTraceProfile traceProfile = (TransactionTraceProfile)txnTraceProfileHolder.get(this.currSequenceNameSpace);
                    if (traceProfile == null) {
                        SequenceTraceStore.constructTraceAndPut(this.currSequenceNameSpace, sh, traceReason);
                        txnTraceProfileHolder.put(this.currSequenceNameSpace, this.txnTraceProfile);
                    } else if (traceProfile.isHighProfile(this.txnTraceProfile)) {
                        traceReason = traceProfile.getTraceReason();
                        SequenceTrace existingTrace = SequenceTraceStore.get(this.currSequenceNameSpace);
                        if (existingTrace == null) {
                            SequenceTraceStore.constructTraceAndPut(this.currSequenceNameSpace, sh, traceReason);
                        } else {
                            SequenceTrace seqTrace = new SequenceTrace(sh, traceReason);
                            if (traceReason != TraceReason.NEW_EXCEPTION.getValue() && existingTrace.getTraceReason() <= traceReason) {
                                SequenceTraceStore.replace(this.currSequenceNameSpace, seqTrace);
                            } else {
                                SequenceTraceStore.put(this.currSequenceNameSpace + Math.random(), seqTrace);
                            }
                        }
                    }
                }
            }
        }
    }

    private int getTraceReason(SequenceHeader sh) {
        int httpRespCode;
        RootTracker rootTracker = sh.getRootTracker();
        if (rootTracker instanceof WebSeqRootTracker && ((WebSeqRootTracker)rootTracker).getSyntheticKey() != null) {
            return TraceReason.SYNTHETIC_MONITORING_TRACE.getValue();
        }
        if (sh.getRootTracker() instanceof WebSeqResponseCodeTracker && (httpRespCode = ((WebSeqResponseCodeTracker)sh.getRootTracker()).getResponseCode()) >= 400 && httpRespCode < 500) {
            return 0;
        }
        if (sh.isSequenceErroneous()) {
            return TraceReason.POINTCUT_EXPERIENCED_EXCEPTION.getValue();
        }
        if (sh.getRecentDelayedSql() != null) {
            return TraceReason.SQL_EXECUTION_DELAYED.getValue();
        }
        AbstractSequenceConfig config = sh.getSequenceConfig();
        if (this.txnTraceProfile.getExternalCallCount() > config.getTraceAfterExternalComponentCount()) {
            return TraceReason.HIGH_EXT_COMPONENT_THROUGHPUT.getValue();
        }
        if ((float)this.txnTraceProfile.getDuration() > config.getSeqTraceThreshold()) {
            return TraceReason.SEQUENCE_HIGH_RESPONSETIME.getValue();
        }
        return 0;
    }

    public void stop() {
        this.stopFlag = true;
        JavaAgent.logger.info("SequenceProcessor " + Thread.currentThread().getName() + " stopping.");
    }

    public static void clearTransactionTraceProfiles() {
        txnTraceProfileHolder.clear();
    }
}

