/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service;

import com.manageengine.apminsight.agent.ExceptionMessages;
import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.ResponseCodeHandler;
import com.manageengine.apminsight.agent.autoupgrade.AgentUpgraderService;
import com.manageengine.apminsight.agent.communication.http.HttpClientBuilder;
import com.manageengine.apminsight.agent.communication.http.HttpConfig;
import com.manageengine.apminsight.agent.config.JavaAgentConfig;
import com.manageengine.apminsight.agent.config.KeyTransactionUtil;
import com.manageengine.apminsight.agent.config.MemoryLeakUserActionHandler;
import com.manageengine.apminsight.agent.context.ContextInfo;
import com.manageengine.apminsight.agent.context.ContextInfoManager;
import com.manageengine.apminsight.agent.exception.FatalException;
import com.manageengine.apminsight.agent.exception.MalformedException;
import com.manageengine.apminsight.agent.instrumentation.InterceptorDefinitionFactory;
import com.manageengine.apminsight.agent.jvm.EnvironmentIdentifier;
import com.manageengine.apminsight.agent.memoryleaks.config.AutomaticLeakDetection;
import com.manageengine.apminsight.agent.metrics.data.transport.MetricDataDispatcher;
import com.manageengine.apminsight.agent.ondemand.OnDemandTasksHandler;
import com.manageengine.apminsight.agent.sequence.SequenceService;
import com.manageengine.apminsight.agent.sequence.process.AsyncSequenceProcessor;
import com.manageengine.apminsight.agent.sequence.process.SequenceProcessor;
import com.manageengine.apminsight.agent.service.AgentServiceConstants;
import com.manageengine.apminsight.agent.service.JmxService;
import com.manageengine.apminsight.agent.service.ScheduledTasksHandler;
import com.manageengine.apminsight.agent.service.profiler.ThreadProfiler;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.apminsight.agent.threads.ThreadDumpService;
import com.manageengine.apminsight.agent.tracing.TrackerService;
import com.manageengine.apminsight.agent.util.HostNameUtil;
import com.manageengine.apminsight.agent.util.StringUtils;
import com.manageengine.org.apache.hc.client5.http.classic.methods.HttpPost;
import com.manageengine.org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import com.manageengine.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import com.manageengine.org.apache.hc.core5.http.HttpEntity;
import com.manageengine.org.apache.hc.core5.http.io.entity.StringEntity;
import com.manageengine.org.apache.logging.log4j.Level;
import com.manageengine.org.json.simple.JSONValue;
import com.manageengine.org.json.simple.parser.JSONParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class JavaAgentService
implements AgentServiceConstants {
    private JavaAgentConfig javaAgentConfig;
    private ScheduledExecutorService scheduledMetricDispatcher;
    private TrackerService tracerService;
    private SequenceService transactionService;
    private SequenceProcessor seqProcessor;
    private ScheduledExecutorService scheduledExecutorService;
    private boolean isAgentServiceStarted = false;
    private CloseableHttpClient httpClient;

    public JavaAgentService(JavaAgentConfig config) throws FatalException {
        this.javaAgentConfig = config;
        this.scheduledMetricDispatcher = Executors.newSingleThreadScheduledExecutor(WorkerThreadFactory.getInstance());
        this.tracerService = new TrackerService();
        this.transactionService = SequenceService.getInstance();
        this.scheduledExecutorService = Executors.newScheduledThreadPool(5, WorkerThreadFactory.getInstance());
        this.httpClient = this.initializeHttpClientForAgentCommunication();
    }

    private CloseableHttpClient initializeHttpClientForAgentCommunication() throws FatalException {
        try {
            int connectTimeout = 10;
            int socketTimeout = 30;
            String sysPropTimeoutValue = System.getProperty("apminsight.communications.timeout");
            if (sysPropTimeoutValue != null) {
                int timeout = -1;
                try {
                    timeout = Integer.parseInt(sysPropTimeoutValue);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (timeout > 0) {
                    connectTimeout = socketTimeout = (timeout = Math.min(timeout, 100));
                } else {
                    JavaAgent.logger.warn("Invalid value '{}' set for property '{}'. Using defaults.", sysPropTimeoutValue, "apminsight.communications.timeout");
                }
            }
            HttpClientBuilder builder = new HttpClientBuilder().setHttpConfig(new HttpConfig(connectTimeout, socketTimeout));
            if (this.javaAgentConfig.getProxyConfig() != null) {
                builder.setProxyConfig(this.javaAgentConfig.getProxyConfig());
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new FatalException("HttpClient initialization failed for agent communication", e);
        }
    }

    public void init() {
        Collection<ContextInfo> contextInfos = ContextInfoManager.getInstance().getAllContexts();
        JavaAgent.logger.info("Identified " + contextInfos.size() + " contexts. Initiating context registration.");
        long sleepTime = 0L;
        int counter = -1;
        int numberOfContextsRegistered = 0;
        boolean isAllContextRegistered = false;
        while (!isAllContextRegistered) {
            if (counter < 60) {
                sleepTime = (counter = (int)((byte)(counter + 1))) < 10 ? 60000L : (counter < 20 ? 120000L : (counter < 26 ? 300000L : (counter < 46 ? 900000L : 3600000L)));
            }
            for (ContextInfo contextInfo : contextInfos) {
                try {
                    if (contextInfo.isRegistered()) continue;
                    this.connect(contextInfo);
                    this.startServices();
                    isAllContextRegistered = ++numberOfContextsRegistered == contextInfos.size();
                }
                catch (IOException e) {
                    this.javaAgentConfig.getLogger().log(Level.WARN, "Could not able to connect with server which receives metrics. Will try to reconnect after " + sleepTime / 60000L + " minute(s). IO Error occurred.", e);
                }
                catch (MalformedException e) {
                    this.javaAgentConfig.getLogger().log(Level.WARN, "MalformedException", e);
                }
                catch (FatalException e) {
                    this.javaAgentConfig.getLogger().log(Level.WARN, "FatalException", e);
                }
                catch (Throwable th) {
                    this.javaAgentConfig.getLogger().error("Exception in Connect. Will try to reconnect after " + sleepTime / 60000L + " minute(s).", th);
                }
            }
            if (isAllContextRegistered) continue;
            this.sleep(sleepTime);
        }
    }

    private void startServices() {
        if (this.javaAgentConfig.agentVerified) {
            return;
        }
        JavaAgent.logger.info("Starting agent services..");
        JmxService.getInstance().initialize();
        this.scheduleMetricDataSender();
        this.scheduleOtherServices();
        if (this.javaAgentConfig.isDebugModeEnabled()) {
            this.javaAgentConfig.scheduleDebugModeDisableTask();
        }
        this.javaAgentConfig.agentVerified = true;
        this.isAgentServiceStarted = true;
    }

    private void scheduleOtherServices() {
        try {
            this.seqProcessor = new SequenceProcessor();
            WorkerThreadFactory.getInstance().newThread(this.seqProcessor, "sequence-processor").start();
            WorkerThreadFactory.getInstance().newThread(new OnDemandTasksHandler(), "ondemand-task-handler").start();
            this.scheduledExecutorService.scheduleAtFixedRate(new AsyncSequenceProcessor(), 0L, 30L, TimeUnit.SECONDS);
            this.scheduledExecutorService.scheduleAtFixedRate(new ScheduledTasksHandler(), 5L, 1L, TimeUnit.MINUTES);
        }
        catch (Throwable th) {
            this.javaAgentConfig.getLogger().log(Level.WARN, "Unable to schedule agent task handler", th);
        }
        try {
            int interval = this.javaAgentConfig.getThreadProfilingInterval();
            this.scheduledExecutorService.scheduleWithFixedDelay(new ThreadProfiler(), 3600L, interval, TimeUnit.SECONDS);
            this.javaAgentConfig.getLogger().info("Thread profiler task scheduled to run every " + interval / 60 + " minutes");
            this.javaAgentConfig.getLogger().info("Thread Profiler enabled: " + this.javaAgentConfig.isThreadProfilingEnabled());
        }
        catch (Throwable th) {
            this.javaAgentConfig.getLogger().warn("Error in scheduling thread profiler. Exception: " + th.getMessage());
        }
    }

    void sleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
            this.javaAgentConfig.refreshNow();
        }
        catch (Throwable ex) {
            this.javaAgentConfig.getLogger().warn(ex.getMessage());
        }
    }

    public TrackerService getTrackerService() {
        return this.tracerService;
    }

    public SequenceService getSequenceService() {
        return this.transactionService;
    }

    public void connect(ContextInfo info) throws IOException, MalformedException, FatalException {
        if (StringUtils.isEmptyString(this.javaAgentConfig.getApplicationName())) {
            throw new RuntimeException("Application name not provided. Valid value for key \"application.name\" must be set");
        }
        LinkedHashMap<String, Map<String, Object>> payload = new LinkedHashMap<String, Map<String, Object>>();
        payload.put("agent_info", this.getConnectInfo(info.getContextName()));
        payload.put("environment", this.javaAgentConfig.getVMEnvironment());
        Map<String, Object> agentSpecificInfo = this.javaAgentConfig.getAgentCollectorSyncConfValues();
        if (agentSpecificInfo != null) {
            payload.put("agent_specific_info", agentSpecificInfo);
        }
        this.javaAgentConfig.getLogger().info("Registering context '" + info.getContextName() + "'");
        Map responseData = (Map)this.sendDataToServer(info, "connect", payload);
        this.javaAgentConfig.getLogger().info("Response received after connecting server: " + responseData);
        Map instanceInfo = (Map)responseData.get("instance-info");
        if (instanceInfo == null || instanceInfo.get("instanceid") == null) {
            throw new RuntimeException("Agent didnot receive instance-id from server.");
        }
        info.setInstanceID((String)instanceInfo.get("instanceid"));
        this.javaAgentConfig.writeAgentInfo(info);
        JavaAgent.logger.log(Level.INFO, "Agent successfully connected to the server.");
        this.javaAgentConfig.removeNonNativeConfigs();
    }

    private Map<String, Object> getConnectInfo(String appName) {
        String id;
        LinkedHashMap<String, Object> connectInfo = new LinkedHashMap<String, Object>();
        connectInfo.put("application.type", this.javaAgentConfig.isDesktopApp() ? "JAVA_DESKTOP" : "JAVA");
        connectInfo.put("agent.version", "6.0");
        connectInfo.put("application.name", StringUtils.isEmptyString(appName) ? this.javaAgentConfig.getApplicationName() : (appName.startsWith("/") ? this.javaAgentConfig.getApplicationName() + appName : this.javaAgentConfig.getApplicationName() + "/" + appName));
        String hostType = EnvironmentIdentifier.getHostType();
        if (!StringUtils.isEmptyString(hostType)) {
            connectInfo.put("host.type", hostType);
        }
        if (!StringUtils.isEmptyString(id = System.getProperty("cloud.instance.id"))) {
            connectInfo.put("cloud.instance.id", id);
        }
        connectInfo.put("fqdn", HostNameUtil.getFQDN());
        connectInfo.put("hostname", this.javaAgentConfig.isUseActualHostname() ? HostNameUtil.getActualHostname() : HostNameUtil.getLocalhostName());
        connectInfo.put("port", this.javaAgentConfig.getAgentServerPort());
        if (this.javaAgentConfig.isContextMonitoringEnabled() && !StringUtils.isEmptyString(appName)) {
            connectInfo.put("context.parent.application", this.javaAgentConfig.getApplicationName());
        }
        if (this.javaAgentConfig.isEnableHostLicense()) {
            connectInfo.put("hostlicense.apply", true);
        }
        return connectInfo;
    }

    private void scheduleMetricDataSender() {
        long interval = JavaAgent.getInstance().getAgentConfig().getAgentPollingInterval();
        this.scheduledMetricDispatcher.scheduleAtFixedRate(new MetricDataDispatcher(JavaAgent.getInstance()), 60000L, 60000L, TimeUnit.MILLISECONDS);
        JavaAgent.logger.info("Scheduled Metric data dispatcher started successfully. Polling interval: " + TimeUnit.SECONDS.toMinutes(interval) + " minute(s)");
    }

    public void shutdown() {
        if (this.isAgentServiceStarted) {
            this.seqProcessor.stop();
            JavaAgent.logger.info("ON DEMAND task handler shutdown: " + OnDemandTasksHandler.shutdown());
            this.scheduledMetricDispatcher.shutdownNow();
            JavaAgent.logger.info("Scheduled Metric data dispatcher shut down successfully.");
            this.scheduledExecutorService.shutdownNow();
            JavaAgent.logger.info("Scheduled executor services shut down successfully.");
        }
    }

    public Object sendDataToServer(ContextInfo contextInfo, String operation, Object data) throws IOException, MalformedException, FatalException {
        URL url = this.getURL(operation, contextInfo.getInstanceID(), null);
        StringWriter out = new StringWriter();
        JSONValue.writeJSONString(data, out);
        StringEntity entity = new StringEntity(((Object)out).toString(), Charset.forName(this.javaAgentConfig.getCharsetEncoding()));
        Level payloadDumpLogLevel = operation.equals("connect") ? Level.INFO : (operation.equals("trace") ? Level.TRACE : Level.DEBUG);
        JavaAgent.logger.log(payloadDumpLogLevel, "Payload being sent for context '" + contextInfo.getContextName() + "' is " + ((Object)out).toString());
        return this.sendData(contextInfo, url, entity);
    }

    public Object sendMultipleFilesToServer(ContextInfo contextInfo, String operation, Map<String, File> files) throws IOException, MalformedException, FatalException {
        URL url = this.getURL(operation, contextInfo.getInstanceID(), null);
        StringBuilder filePaths = new StringBuilder();
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        for (Map.Entry<String, File> entry : files.entrySet()) {
            entityBuilder = entityBuilder.addBinaryBody(entry.getKey(), entry.getValue());
            filePaths.append(entry.getValue().getAbsolutePath()).append(';');
        }
        HttpEntity entity = entityBuilder.build();
        JavaAgent.logger.debug("Files being sent for context '" + contextInfo.getContextName() + "' is " + filePaths.toString());
        return this.sendData(contextInfo, url, entity);
    }

    public Object sendITAutomationActionResponse(ContextInfo contextInfo, String operation, String actionId, Object data) throws IOException, MalformedException, FatalException {
        URL url = this.getURL(operation, contextInfo.getInstanceID(), actionId);
        HttpEntity entity = null;
        JavaAgent.logger.info("Sending IT automation action response of type " + data.getClass().getName() + ". Action ID: " + actionId);
        if (data instanceof File) {
            entity = MultipartEntityBuilder.create().addBinaryBody("file", (File)data).build();
            JavaAgent.logger.debug("File being sent for context '" + contextInfo.getContextName() + "' is " + ((File)data).getAbsolutePath());
        } else {
            StringWriter out = new StringWriter();
            JSONValue.writeJSONString(data, out);
            entity = new StringEntity(((Object)out).toString(), Charset.forName(this.javaAgentConfig.getCharsetEncoding()));
            JavaAgent.logger.info("Payload being sent for context '" + contextInfo.getContextName() + "' is " + ((Object)out).toString());
        }
        return this.sendData(contextInfo, url, entity);
    }

    private URL getURL(String operation, String instanceId, String actionId) throws MalformedException, FatalException {
        if (StringUtils.isEmptyString(operation)) {
            throw new IllegalArgumentException("Operation cannot be null or empty: " + operation);
        }
        if (!"connect".equals(operation) && StringUtils.isEmptyString(instanceId)) {
            throw new FatalException("Invalid Instance ID (empty). Aborting metric dispatch.");
        }
        StringBuilder uriBuilder = new StringBuilder(this.javaAgentConfig.getAgentCollectorConnectionURL()).append(operation);
        uriBuilder.append(this.getConnectionVitalQueryString(instanceId));
        if (actionId != null) {
            uriBuilder.append('&');
            uriBuilder.append("action.id").append('=').append(actionId);
        }
        try {
            URL url = new URL(uriBuilder.toString());
            JavaAgent.logger.log(Level.INFO, "[JavaAgentService] URL to be executed: {}", (Object)url.toExternalForm().replaceAll("license.key=[^&]+", "license.key=**"));
            return url;
        }
        catch (MalformedURLException e) {
            throw new MalformedException("MalformedURLException", e);
        }
    }

    private Object sendData(ContextInfo contextInfo, URL url, HttpEntity entity) throws IOException, MalformedException, FatalException {
        Object response = null;
        if (entity == null) {
            throw new FatalException("Request entity object is null, aborting communication");
        }
        HttpPost request = new HttpPost(url.toString());
        if (entity instanceof StringEntity) {
            request.setHeader("content-type", "application/octet-stream");
            request.setHeader("accept-encoding", "application/json");
        }
        request.setEntity(entity);
        CloseableHttpResponse resp = this.httpClient.execute(request);
        int responseCode = resp.getCode();
        JavaAgent.logger.log(Level.TRACE, "The response code is {}", (Object)responseCode);
        if (responseCode != 200) {
            throw new RuntimeException(ExceptionMessages.getMessage("HttpException:Message \" {0} \"received with response code {1}", new Object[]{response, responseCode}));
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));){
            response = new JSONParser().parse(in);
            JavaAgent.logger.debug("response got is: " + response);
        }
        return this.parseResponse(contextInfo, response);
    }

    private Object parseResponse(ContextInfo contextInfo, Object response) throws FatalException {
        Object updateAvailableValue;
        Object dumpThreads;
        Object onDemandThreadProfileRequest;
        Object keyTransactionsConfig;
        if (response == null || !(response instanceof Map)) {
            return null;
        }
        Map responseMap = (Map)response;
        if (responseMap.isEmpty()) {
            return null;
        }
        boolean result = Boolean.valueOf(String.valueOf(responseMap.get("result")));
        Map responseData = (Map)responseMap.get("data");
        if (!result) {
            Object exception;
            Object v0 = exception = responseData != null ? responseData.get("exception") : null;
            if (exception != null) {
                throw new RuntimeException(ExceptionMessages.getMessage("{0} occurred in the server with message \"{1}\"", ((Map)exception).values().toArray()));
            }
            throw new RuntimeException("Some error occurred");
        }
        if (responseData == null) {
            return null;
        }
        Object cResponseCodeObj = responseData.get("response-code");
        if (cResponseCodeObj != null) {
            Integer responseCodeAsInt = StringUtils.getAsInteger(cResponseCodeObj.toString());
            JavaAgent.logger.info("Collector Response Code: " + responseCodeAsInt + '(' + ResponseCodeHandler.getResponseCode(responseCodeAsInt).getResponseMessage() + ')');
            boolean processFurther = ResponseCodeHandler.processResponseCode(contextInfo, responseCodeAsInt);
            if (!this.javaAgentConfig.isContextMonitoringEnabled() && !processFurther) {
                throw new FatalException("Collector response code: " + cResponseCodeObj.toString() + '(' + ResponseCodeHandler.getResponseCode(responseCodeAsInt).getResponseMessage() + "). Cannot proceed further.");
            }
        }
        Map customizedConfig = (Map)responseData.get("custom_config_info");
        Map agentSpecificInfo = (Map)responseData.get("agent_specific_info");
        if (customizedConfig == null) {
            customizedConfig = agentSpecificInfo;
        } else if (agentSpecificInfo != null) {
            customizedConfig.putAll(agentSpecificInfo);
        }
        agentSpecificInfo = null;
        if (customizedConfig != null && !customizedConfig.isEmpty()) {
            JavaAgent.logger.info("Reinitialising agent configuration with values received from server: " + customizedConfig);
            this.javaAgentConfig.updateAgentUserConfig(customizedConfig);
            this.javaAgentConfig.reinit();
            contextInfo.updateConfig(customizedConfig);
            Map customInstrumentation = (Map)customizedConfig.get("custom.instrumentation");
            if (customInstrumentation != null) {
                InterceptorDefinitionFactory.getInstance().loadInterceptorsFromServer(customInstrumentation);
            }
        }
        if ((keyTransactionsConfig = responseData.get("transaction_specific_config")) != null) {
            try {
                KeyTransactionUtil.initialize((List)keyTransactionsConfig);
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("Error processing key transaction config. Exception: " + th.getMessage());
            }
        }
        if ((onDemandThreadProfileRequest = responseData.get("thread.profile.duration")) != null) {
            try {
                int topN = Integer.parseInt(responseData.get("n_value").toString());
                int threadProfilingDuration = Integer.parseInt(onDemandThreadProfileRequest.toString()) * 60;
                OnDemandTasksHandler.addTask(new ThreadProfiler(threadProfilingDuration, this.javaAgentConfig.getThreadSamplingInterval(), topN));
            }
            catch (Throwable th) {
                JavaAgent.logger.warn("Error processing ON-DEMAND thread profiler request. Exception: " + th.getMessage());
            }
        }
        if (responseData.containsKey("memleak.profiling.start")) {
            try {
                int captureDuration = Integer.parseInt(responseData.get("memleak.profiling.duration").toString());
                int samplingInterval = Integer.parseInt(responseData.get("memleak.sampling.interval").toString());
                MemoryLeakUserActionHandler.startMemoryLeakProfiling(captureDuration, samplingInterval);
            }
            catch (Throwable th) {
                JavaAgent.logger.error("Error starting memory leak on demand request. Exception: " + th.getMessage());
            }
        }
        if (AutomaticLeakDetection.isActive()) {
            List userEvents;
            if (responseData.containsKey("memleak.profiling.stop")) {
                MemoryLeakUserActionHandler.stopMemoryLeakProfiling();
            }
            if ((userEvents = (List)responseData.get("memleak.user.action")) != null && userEvents.size() > 0) {
                MemoryLeakUserActionHandler.processUserTriggeredActions(userEvents);
            }
        }
        if ((dumpThreads = responseData.get("generate.thread.dump")) != null && Boolean.parseBoolean(dumpThreads.toString())) {
            String actionId = (String)responseData.get("action.id");
            OnDemandTasksHandler.addTask(new ThreadDumpService(false, actionId));
        }
        if ((updateAvailableValue = responseData.get("agent_update_available")) != null) {
            JavaAgent.logger.info("Agent got notified about new update availability - " + updateAvailableValue.toString());
            OnDemandTasksHandler.addTask(new AgentUpgraderService());
        }
        return responseData;
    }

    public String getConnectionVitalQueryString(String instanceID) {
        StringBuilder qs = new StringBuilder();
        int queryStringAdder = 63;
        if (!StringUtils.isEmptyString(instanceID)) {
            qs.append((char)queryStringAdder).append("instance_id").append('=').append(instanceID);
            queryStringAdder = 38;
        }
        if (!StringUtils.isEmptyString(this.javaAgentConfig.getLicenseKey())) {
            qs.append((char)queryStringAdder).append("license.key").append('=').append(this.javaAgentConfig.getLicenseKey());
        }
        return qs.toString().intern();
    }

    private void printJSONToFile(String operation, Object data) {
        try {
            FileWriter writer = new FileWriter(new File(this.javaAgentConfig.getAgentInstallDir(), System.currentTimeMillis() + operation + ".txt"));
            JSONValue.writeJSONString(data, writer);
            writer.flush();
            writer.close();
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("Error occurred while writing JSON to file. Exception: " + th.getMessage());
        }
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }
}

