/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service.profiler;

import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.metric.MetricConstants;
import com.manageengine.org.json.simple.JSONStreamAware;
import com.manageengine.org.json.simple.JSONValue;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ProfilerData
implements JSONStreamAware,
MetricConstants {
    private static Map<Integer, String> stacktraceElementID = new HashMap<Integer, String>();
    private final long threadID;
    private String currentMethod;
    private long startCPUTime;
    private long startMemalloc;
    private long cputime;
    private long memalloc;
    private Map<Integer, Integer> callCount = new HashMap<Integer, Integer>(){

        @Override
        public Integer put(Integer key, Integer value) {
            if (key == null || this.size() == 20) {
                return 0;
            }
            Integer old = super.put(key, value);
            if (old != null) {
                super.put(key, old + value);
            }
            return 0;
        }
    };
    private static Comparator<Map.Entry<Integer, Integer>> sortByValue = new Comparator<Map.Entry<Integer, Integer>>(){

        @Override
        public int compare(Map.Entry<Integer, Integer> entry1, Map.Entry<Integer, Integer> entry2) {
            return entry1.getValue().compareTo(entry2.getValue()) * -1;
        }
    };

    public ProfilerData(long threadID) {
        this.threadID = threadID;
        this.startCPUTime = ThreadMxBeanUtil.getThreadTotalCpuTimeInNanoSec(threadID);
        this.startMemalloc = ThreadMxBeanUtil.getThreadAllocatedBytes(threadID);
    }

    public void addProfilerData(String stacktraceElement) {
        int hashcode = stacktraceElement.hashCode();
        stacktraceElementID.put(hashcode, stacktraceElement);
        this.callCount.put(hashcode, 1);
        this.cputime = ThreadMxBeanUtil.getThreadTotalCpuTimeInNanoSec(this.threadID);
        this.memalloc = ThreadMxBeanUtil.getThreadAllocatedBytes(this.threadID);
    }

    public void addCurrentMethod(String stacktraceElement) {
        this.currentMethod = stacktraceElement;
    }

    public void mergeMethodCount(ProfilerData profilerData) {
        this.callCount.putAll(profilerData.callCount);
    }

    private List<Map<String, Object>> getMethodCallCount() {
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        for (Map.Entry<Integer, Integer> entry : this.callCount.entrySet()) {
            HashMap<String, Object> stacktrace = new HashMap<String, Object>();
            stacktrace.put("method", stacktraceElementID.get(entry.getKey()));
            stacktrace.put("count", entry.getValue());
            data.add(stacktrace);
        }
        return data;
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("threadID", this.threadID);
        data.put("currMethod", this.currentMethod);
        data.put("stacktrace", this.getMethodCallCount());
        data.put("cputime", this.cputime > this.startCPUTime ? TimeUnit.NANOSECONDS.toMillis(this.cputime - this.startCPUTime) : 0L);
        data.put("memalloc", this.memalloc > this.startMemalloc ? (this.memalloc - this.startMemalloc) / 0x100000L : 0L);
        JSONValue.writeJSONString(data, out);
    }

    public Map<String, String> getTopNMostUsedMethods(int n) {
        ArrayList<Map.Entry<Integer, Integer>> mapEntries = new ArrayList<Map.Entry<Integer, Integer>>(this.callCount.entrySet());
        Collections.sort(mapEntries, sortByValue);
        HashMap<String, String> methodsToInstrument = new HashMap<String, String>();
        n = mapEntries.size() > n ? n : mapEntries.size();
        for (int i = 0; i < n; ++i) {
            int hashcode = (Integer)((Map.Entry)mapEntries.get(i)).getKey();
            String stacktraceElement = stacktraceElementID.get(hashcode);
            if (stacktraceElement == null) continue;
            String[] entry = stacktraceElement.split(":");
            String className = entry[0].replaceAll("\\.", "/");
            String methods = (String)methodsToInstrument.get(className);
            if (methods != null) {
                methodsToInstrument.put(className, methods + "," + entry[1]);
                continue;
            }
            methodsToInstrument.put(className, entry[1]);
        }
        return methodsToInstrument;
    }
}

