/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service.profiler;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.service.profiler.ProfilerData;
import com.manageengine.apminsight.agent.smart.SmartPackageFilter;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.org.apache.logging.log4j.Level;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public class ThreadSamplingService
implements Runnable {
    private Map<Long, ProfilerData> profilerData;
    private int profilingStacktraceDepth;
    private int numberOfThreads;

    public ThreadSamplingService(Map<Long, ProfilerData> profilerData, int profilingStacktraceDepth, int numberOfThreads) {
        this.profilerData = profilerData;
        this.profilingStacktraceDepth = profilingStacktraceDepth;
        this.numberOfThreads = numberOfThreads;
    }

    @Override
    public void run() {
        try {
            Thread.currentThread().setName("apminsight-thread-sampler");
            final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
            ThreadInfo[] allThreadsInfo = threadMxBean.getThreadInfo(threadMxBean.getAllThreadIds(), 1);
            if (this.numberOfThreads > 0) {
                Arrays.sort(allThreadsInfo, new Comparator<ThreadInfo>(){

                    @Override
                    public int compare(ThreadInfo info1, ThreadInfo info2) {
                        try {
                            return threadMxBean.getThreadCpuTime(info1.getThreadId()) < threadMxBean.getThreadCpuTime(info2.getThreadId()) ? 1 : -1;
                        }
                        catch (Throwable th) {
                            return 0;
                        }
                    }
                });
                this.numberOfThreads = allThreadsInfo.length < this.numberOfThreads ? allThreadsInfo.length : this.numberOfThreads;
                ThreadInfo[] allThreadsInfos = new ThreadInfo[this.numberOfThreads];
                System.arraycopy(allThreadsInfo, 0, allThreadsInfos, 0, this.numberOfThreads);
                allThreadsInfo = allThreadsInfos;
                ThreadInfo[] threadInfoArray = null;
            }
            for (ThreadInfo threadInfo : allThreadsInfo) {
                if (Thread.currentThread().isInterrupted()) {
                    JavaAgent.logger.info("[ThreadSamplingService] Thread is interrupted. Thread Sampling stopped");
                    return;
                }
                if (!this.isProfilableThread(threadInfo)) continue;
                try {
                    JavaAgent.logger.trace("Sampling thread: " + threadInfo.getThreadName());
                    StackTraceElement[] stacktrace = threadMxBean.getThreadInfo(threadInfo.getThreadId(), this.profilingStacktraceDepth).getStackTrace();
                    ProfilerData profilerData = this.profilerData.get(threadInfo.getThreadId());
                    if (profilerData == null) {
                        profilerData = new ProfilerData(threadInfo.getThreadId());
                        this.profilerData.put(threadInfo.getThreadId(), profilerData);
                    }
                    for (StackTraceElement stacktraceElement : stacktrace) {
                        String className = stacktraceElement.getClassName();
                        if (!SmartPackageFilter.getInstance().isUserPackage(className)) continue;
                        profilerData.addProfilerData(className + ":" + stacktraceElement.getMethodName());
                        JavaAgent.logger.trace("Adding method for tracking: " + stacktraceElement.toString());
                    }
                    profilerData.addCurrentMethod(stacktrace[0].toString());
                }
                catch (Exception e) {
                    JavaAgent.logger.warn("Exception while profiling thread (Thread might have died recently). Exception: " + e.getMessage());
                }
            }
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "Error occurred while profiling the threads.", th);
        }
        JavaAgent.logger.log(Level.DEBUG, "[ThreadSamplingService] Sampling completed.");
    }

    private boolean isProfilableThread(ThreadInfo threadInfo) {
        if (threadInfo == null || threadInfo.getThreadState() != Thread.State.RUNNABLE) {
            return false;
        }
        if (WorkerThreadFactory.getInstance().isAgentThread(threadInfo.getThreadId())) {
            return false;
        }
        if (threadInfo.getStackTrace().length == 0) {
            return false;
        }
        String currentExecutingMethod = threadInfo.getStackTrace()[0].getMethodName();
        return !currentExecutingMethod.matches("wait|poll|epollWait|park|sleep|accept|socketAccept");
    }
}

