/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.service.profiler;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.jvm.monitor.ThreadMxBeanUtil;
import com.manageengine.apminsight.agent.service.profiler.ProfilerDatav2;
import com.manageengine.apminsight.agent.thread.WorkerThreadFactory;
import com.manageengine.apminsight.agent.threads.ThreadDumpService;
import com.manageengine.org.apache.logging.log4j.Level;
import java.io.File;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ThreadSamplingServiceV2
implements Runnable {
    private ProfilerDatav2 profilerData;
    private int numberOfThreads;
    private int topN;
    private boolean saveThisDump;

    public ThreadSamplingServiceV2(ProfilerDatav2 profilerData, int numberOfThreads, int topNThreads, boolean saveThisDump) {
        this.profilerData = profilerData;
        this.numberOfThreads = numberOfThreads;
        this.topN = topNThreads;
        this.saveThisDump = saveThisDump;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ThreadInfo[] dump = null;
        try {
            dump = ThreadMxBeanUtil.dumpAllThreads(false);
            List<ThreadInfo> allThreadsInfo = new ArrayList<ThreadInfo>(Arrays.asList(dump));
            Collections.sort(allThreadsInfo, new Comparator<ThreadInfo>(){

                @Override
                public int compare(ThreadInfo info1, ThreadInfo info2) {
                    try {
                        long cpu1 = ThreadMxBeanUtil.getThreadTotalCpuTimeInNanoSec(info1.getThreadId());
                        long cpu2 = ThreadMxBeanUtil.getThreadTotalCpuTimeInNanoSec(info2.getThreadId());
                        if (cpu1 <= 0L || cpu2 <= 0L) {
                            return -1;
                        }
                        return cpu1 < cpu2 ? 1 : (cpu1 == cpu2 ? 0 : -1);
                    }
                    catch (Throwable th) {
                        return 0;
                    }
                }
            });
            if (this.numberOfThreads > 0) {
                this.numberOfThreads = allThreadsInfo.size() < this.numberOfThreads ? allThreadsInfo.size() : this.numberOfThreads;
                allThreadsInfo = allThreadsInfo.subList(0, this.numberOfThreads);
            }
            for (ThreadInfo threadInfo : allThreadsInfo) {
                if (Thread.currentThread().isInterrupted()) {
                    JavaAgent.logger.info("[ThreadSamplingService] Thread is interrupted. Thread Sampling stopped");
                    return;
                }
                if (!this.isProfilableThread(threadInfo)) continue;
                this.profilerData.addStackTrace(threadInfo.getStackTrace());
            }
            this.profilerData.setHighCPUThreads(allThreadsInfo.subList(0, this.topN));
            Collections.sort(allThreadsInfo, new Comparator<ThreadInfo>(){

                @Override
                public int compare(ThreadInfo info1, ThreadInfo info2) {
                    try {
                        return ThreadMxBeanUtil.getThreadAllocatedBytes(info1.getThreadId()) < ThreadMxBeanUtil.getThreadAllocatedBytes(info2.getThreadId()) ? 1 : -1;
                    }
                    catch (Throwable th) {
                        return 0;
                    }
                }
            });
            this.profilerData.setHighMemoryThreads(allThreadsInfo.subList(0, this.topN));
        }
        catch (Throwable th) {
            JavaAgent.logger.log(Level.WARN, "Error occurred while sample profiling the threads.", th);
        }
        finally {
            if (dump != null && this.saveThisDump) {
                try {
                    ThreadDumpService dumpService = new ThreadDumpService(this.saveThisDump, null);
                    File dumpFile = dumpService.dumpToFile(dump);
                    this.profilerData.saveDump(dumpFile);
                }
                catch (Throwable th) {
                    JavaAgent.logger.log(Level.WARN, "Unable to save dump file, error occurred.", th);
                }
            }
        }
        JavaAgent.logger.log(Level.DEBUG, "[ThreadSamplingService] Sampling completed.");
    }

    private boolean isProfilableThread(ThreadInfo threadInfo) {
        if (threadInfo == null || threadInfo.getThreadState() != Thread.State.RUNNABLE) {
            return false;
        }
        if (WorkerThreadFactory.getInstance().isAgentThread(threadInfo.getThreadId())) {
            return false;
        }
        if (threadInfo.getStackTrace().length == 0) {
            return false;
        }
        String currentExecutingMethod = threadInfo.getStackTrace()[0].getMethodName();
        return !currentExecutingMethod.matches("wait|poll|epollWait|park|sleep|accept|accept0|socketAccept");
    }
}

