/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers;

import com.manageengine.apminsight.agent.JavaAgent;
import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.tracing.AsyncTracerService;
import com.manageengine.apminsight.agent.trackers.AbstractTracker;
import com.manageengine.apminsight.agent.trackers.CalleeAsyncRootTracker;
import com.manageengine.apminsight.agent.trackers.PsuedoTracker;
import com.manageengine.apminsight.agent.trackers.background.BackgroundSeqRootTracker;
import java.text.MessageFormat;

public class CallerAsyncRootTracker
extends BackgroundSeqRootTracker {
    private static final String SIGNATURE_PREFIX = "[ASYNC Call- {0}] ";
    private AbstractTracker calleeRootTracker;
    private Object callbackObj;
    private ASYNC_STATE txnState = ASYNC_STATE.RUNNING;
    private String calleeThreadInfo;

    public CallerAsyncRootTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.isLeafTracker = true;
    }

    public void setCallbackObj(Object obj) {
        if (obj == null) {
            return;
        }
        this.callbackObj = obj;
        AsyncTracerService.getInstance().addToWaitList(obj.hashCode(), this);
    }

    public Object getCallbackObj() {
        return this.callbackObj;
    }

    public void setCalleeAsyncTracker(AbstractTracker calleeAsyncRootTracker) {
        if (this.calleeRootTracker == null) {
            this.calleeRootTracker = calleeAsyncRootTracker;
        }
    }

    public void markCompleted(Object returnObj) {
        this.txnState = ASYNC_STATE.COMPLETED;
        this.quit(0, null);
    }

    public void markFailed(Throwable th) {
        this.txnState = ASYNC_STATE.FAILED;
        this.quit(th);
    }

    public void markCancelled() {
        this.markCompleted(null);
        this.txnState = ASYNC_STATE.CANCELLED;
    }

    public void markTimedOut() {
        this.markFailed(new Exception("Async call taking too much time to complete, aborted tracking performance"));
        this.txnState = ASYNC_STATE.TIMEOUT;
    }

    public void linkCalleeTracker() {
        if (this.calleeRootTracker == null || this.txnState == ASYNC_STATE.TIMEOUT) {
            return;
        }
        if (this.child != null) {
            JavaAgent.logger.warn("AsyncRootTracker has a child tracker {}, appending callee as first child.", this.child);
            this.calleeRootTracker.sibling = this.child;
            this.child = this.calleeRootTracker;
            return;
        }
        try {
            this.checkAndIncludeWaitTimeTracker();
            this.child = this.calleeRootTracker.child;
            this.calleeThreadInfo = ((CalleeAsyncRootTracker)this.calleeRootTracker).getThreadInfo();
            this.isLeafTracker = false;
            this.calleeRootTracker = null;
        }
        catch (Throwable th) {
            JavaAgent.logger.warn("[CallerAsync] Unable to link callee tracker to caller. Exception: {}", th.getMessage());
        }
    }

    private void checkAndIncludeWaitTimeTracker() {
        long waitTimeIfAny = this.calleeRootTracker.getStartTime() - this.startTime;
        if (waitTimeIfAny > 100L) {
            PsuedoTracker waitTimeTracker = new PsuedoTracker(this.startTime, (int)waitTimeIfAny, "Waiting for thread, as the threadpool was full");
            waitTimeTracker.sibling = this.calleeRootTracker.child;
            this.calleeRootTracker.child = waitTimeTracker;
        }
    }

    public String getState() {
        return this.txnState.name();
    }

    public boolean isTxnCompleted() {
        return this.txnState != ASYNC_STATE.RUNNING;
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.duration, this.isErroneous());
        return true;
    }

    public String getTrackerSignaturePrefix() {
        return MessageFormat.format(SIGNATURE_PREFIX, new Object[]{this.txnState});
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTrackerSignaturePrefix());
        sb.append(' ');
        if (this.txnState == ASYNC_STATE.TIMEOUT) {
            sb.append(this.error.getMessage());
        } else {
            if (this.error != null) {
                sb.append("Exception: " + this.error.getClass().getSimpleName());
            }
            if (this.calleeThreadInfo != null) {
                sb.append(this.calleeThreadInfo);
            }
        }
        return sb.toString();
    }

    public static enum ASYNC_STATE {
        RUNNING,
        COMPLETED,
        FAILED,
        CANCELLED,
        TIMEOUT;

    }
}

