/*
 * Decompiled with CFR 0.152.
 */
package com.manageengine.apminsight.agent.trackers.cache;

import com.manageengine.apminsight.agent.instrumentation.interceptor.PointcutProperties;
import com.manageengine.apminsight.agent.metrics.ComponentMetric;
import com.manageengine.apminsight.agent.metrics.MetricData;
import com.manageengine.apminsight.agent.sequence.SequenceHeader;
import com.manageengine.apminsight.agent.trackers.DefaultTracker;
import com.manageengine.apminsight.agent.util.InetAddressUtil;
import com.manageengine.apminsight.agent.util.StringUtils;

public class CachedFrameworkTracker
extends DefaultTracker {
    private String serverAddr;
    private String key = "";
    private final int max_key_length = 60;

    public CachedFrameworkTracker(PointcutProperties pointcutProperties, Object thiz, Object[] args) {
        super(pointcutProperties, thiz, args);
        this.isLeafTracker = true;
        try {
            if (args != null) {
                if (args[0] instanceof String) {
                    this.key = (String)args[0];
                } else if (args[0] instanceof String[]) {
                    int length = ((String[])args[0]).length;
                    this.key = length > 1 ? ((String[])args[0])[0] + " & " + (length - 1) + " others" : ((String[])args[0])[0];
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean generateMetric(SequenceHeader seqHeader, int childDuration, MetricData metricData) {
        this.serverAddr = InetAddressUtil.standardizeServerAddress(this.serverAddr);
        ((ComponentMetric)metricData).recordComponentData(this.pointcutProperties.getComponent(), this.serverAddr, this.duration - childDuration, this.isErroneous());
        return true;
    }

    public void setServerAddr(String serverAddr) {
        this.serverAddr = serverAddr;
    }

    @Override
    public String getTrackerSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append(this.pointcutProperties.getComponent().toString());
        signature.append(" - ");
        if (this.pointcutProperties.getInterceptedClassName().contains("Pipeline")) {
            signature.append("PIPELINE ");
        }
        signature.append(this.pointcutProperties.getInterceptedMethodName().toUpperCase());
        signature.append(" - ");
        signature.append(this.key.length() > 60 ? this.key.substring(0, 60) + ".." : this.key);
        if (!StringUtils.isEmptyString(this.serverAddr)) {
            signature.append(" - ");
            try {
                signature.append(this.serverAddr.split("/")[1]);
            }
            catch (Exception e) {
                signature.append(this.serverAddr);
            }
        }
        if (this.isErroneous()) {
            signature.append(" Error: ");
            signature.append(this.error.getClass().getSimpleName());
        }
        return signature.toString();
    }
}

